/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util.status;

import com.calculatorsteam.dynamicpack.DynamicPackMod;
import com.calculatorsteam.dynamicpack.util.JsonUtil;
import com.calculatorsteam.dynamicpack.util.Urls;
import com.calculatorsteam.dynamicpack.util.enums.Loader;
import com.calculatorsteam.dynamicpack.util.log.Out;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/calculatorsteam/dynamicpack/util/status/StatusChecker;", "", "<init>", "()V", "URL", "", "isUpdateAvailable", "", "isFormatActual", "isSafe", "isChecked", "check", "", "getLatestKeyForPlatform", "loader", "Lcom/calculatorsteam/dynamicpack/util/enums/Loader;", "isBlockUpdating", "remoteType", "isModUpdateAvailable", "dynamicpack"})
public final class StatusChecker {
    @NotNull
    public static final StatusChecker INSTANCE = new StatusChecker();
    @NotNull
    private static final String URL = "https://calculatorsteam.github.io/DynamicPack/dynamicpack.status.v1.json";
    private static boolean isUpdateAvailable;
    private static boolean isFormatActual;
    private static boolean isSafe;
    private static boolean isChecked;

    private StatusChecker() {
    }

    @JvmStatic
    public static final void check() {
        if (isChecked) {
            return;
        }
        Out.println("Checking status...");
        try {
            String string = Urls.parseTextContent(URL, 524288L);
            if (string == null) {
                return;
            }
            String s = string;
            JsonObject j = JsonUtil.fromString(s);
            String platformKey = INSTANCE.getLatestKeyForPlatform(DynamicPackMod.Companion.getLoader());
            JsonObject lat = j.getAsJsonObject(platformKey);
            Intrinsics.checkNotNull((Object)lat);
            isUpdateAvailable = JsonUtil.getLong(lat, "build") > 51L;
            isSafe = JsonUtil.getLong(lat, "safe") <= 51L;
            isFormatActual = JsonUtil.getLong(lat, "format") <= 51L;
            isChecked = true;
            Out.println("Status checked! platformKey=" + platformKey + ", isSafe=" + isSafe + ", isFormatActual=" + isFormatActual + ", isUpdateAvailable=" + isUpdateAvailable);
        }
        catch (Exception e) {
            Out.error("Error while checking status...", e);
        }
    }

    private final String getLatestKeyForPlatform(Loader loader) {
        Loader loader2 = loader;
        return switch (loader2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loader2.ordinal()]) {
            case -1, 1 -> "latest_version";
            case 2 -> "latest_version_fabric";
            case 3 -> "latest_version_forge";
            case 4 -> "latest_version_neoforge";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    public static final boolean isBlockUpdating(@NotNull String remoteType) {
        Intrinsics.checkNotNullParameter((Object)remoteType, (String)"remoteType");
        return Intrinsics.areEqual((Object)remoteType, (Object)"modrinth") ? false : !StatusChecker.isSafe();
    }

    @JvmStatic
    public static final boolean isModUpdateAvailable() {
        return isUpdateAvailable;
    }

    @JvmStatic
    public static final boolean isSafe() {
        return isSafe;
    }

    @JvmStatic
    public static final boolean isFormatActual() {
        return isFormatActual;
    }

    @JvmStatic
    public static final boolean isChecked() {
        return isChecked;
    }

    static {
        isFormatActual = true;
        isSafe = true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Loader.values().length];
            try {
                nArray[Loader.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Loader.FABRIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Loader.FORGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Loader.NEO_FORGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

