/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack;

import com.calculatorsteam.dynamicpack.util.log.Out;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u0017J\r\u0010\u001a\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\r\u0010\u001e\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u001bJ\r\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001f\u0010\u001bJ\u001d\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0011\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u000e\u00a2\u0006\u0004\b%\u0010\u001bJ\r\u0010&\u001a\u00020\u000e\u00a2\u0006\u0004\b&\u0010\u001bR\u0014\u0010'\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0016\u0010*\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u0017\u00100\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b0\u0010.\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b3\u0010.R\u0017\u00104\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b4\u0010,\u001a\u0004\b5\u00106R\u0017\u00107\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b7\u0010,\u001a\u0004\b8\u00106R\u0017\u00109\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b9\u0010,\u001a\u0004\b:\u00106R\u0017\u0010;\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b;\u0010,\u001a\u0004\b<\u00106R\u0017\u0010=\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b=\u0010,\u001a\u0004\b>\u00106R\u0014\u0010?\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b?\u0010.R\u0017\u0010@\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b@\u0010,\u001a\u0004\bA\u00106R\u0014\u0010B\u001a\u00020 8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bD\u0010.R\u0016\u0010E\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010CR\u0014\u0010F\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bF\u0010,R\u0014\u0010G\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bG\u0010.R\u0014\u0010H\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bH\u0010.R\u0017\u0010I\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\bI\u0010.\u001a\u0004\bJ\u00102R\u0014\u0010L\u001a\u00020K8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u001a\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00040N8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010P\u00a8\u0006Q"}, d2={"Lcom/calculatorsteam/dynamicpack/Constants;", "", "<init>", "()V", "", "host", "requester", "", "addAllowedHosts$dynamicpack", "(Ljava/lang/String;Ljava/lang/Object;)V", "addAllowedHosts", "url", "getUrlHost", "(Ljava/lang/String;)Ljava/lang/String;", "", "isUrlHostTrusted", "(Ljava/lang/String;)Z", "", "mb", "megabyte", "(J)J", "bytesPerSec", "speedToString", "(J)Ljava/lang/String;", "s", "secondsToString", "isBlockAllNotTrustedNetworks", "()Z", "isRelease", "isLocalHostAllowed", "isFileDebugSchemeAllowed", "isHTTPTrafficAllowed", "", "bytesRead", "total", "debugNetwork", "(IJ)V", "isDebugLogs", "isDebugMessageOnWorldJoin", "DEBUG", "Z", "DEBUG_ALLOW_UNSECURE", "DEBUG_LOGS", "VERSION_BUILD", "J", "VERSION_NAME_MOD", "Ljava/lang/String;", "VERSION_NAME_BRANCH", "VERSION_NAME", "getVERSION_NAME", "()Ljava/lang/String;", "MOD_ID", "DYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT", "getDYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT", "()J", "MODRINTH_HTTPS_FILE_SIZE_LIMIT", "getMODRINTH_HTTPS_FILE_SIZE_LIMIT", "MOD_MODTINTH_API_LIMIT", "getMOD_MODTINTH_API_LIMIT", "GZIP_LIMIT", "getGZIP_LIMIT", "MOD_FILES_LIMIT", "getMOD_FILES_LIMIT", "MODRINTH_URL", "NETWORK_STAT_RESET_LIMIT", "getNETWORK_STAT_RESET_LIMIT", "MAX_ATTEMPTS_TO_DOWNLOAD_FILE", "I", "TEMP_DIR_NAME", "URLS_BUFFER_SIZE", "HTTP_MINIMAL_HEADER_SIZE", "CLIENT_FILE", "MINECRAFT_META", "UNKNOWN_PACK_MCMETA", "getUNKNOWN_PACK_MCMETA", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "", "ALLOWED_HOSTS", "Ljava/util/Set;", "dynamicpack"})
@SourceDebugExtension(value={"SMAP\nConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constants.kt\ncom/calculatorsteam/dynamicpack/Constants\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1761#2,3:166\n*S KotlinDebug\n*F\n+ 1 Constants.kt\ncom/calculatorsteam/dynamicpack/Constants\n*L\n111#1:166,3\n*E\n"})
public final class Constants {
    @NotNull
    public static final Constants INSTANCE;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_ALLOW_UNSECURE = false;
    @JvmField
    public static boolean DEBUG_LOGS;
    public static final long VERSION_BUILD = 51L;
    @NotNull
    public static final String VERSION_NAME_MOD = "1.2.1";
    @NotNull
    public static final String VERSION_NAME_BRANCH = "mc1.21.4";
    @NotNull
    private static final String VERSION_NAME;
    @NotNull
    public static final String MOD_ID = "dynamicpack";
    private static final long DYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT;
    private static final long MODRINTH_HTTPS_FILE_SIZE_LIMIT;
    private static final long MOD_MODTINTH_API_LIMIT;
    private static final long GZIP_LIMIT;
    private static final long MOD_FILES_LIMIT;
    @NotNull
    public static final String MODRINTH_URL = "https://modrinth.com/mod/dynamicpack";
    private static final long NETWORK_STAT_RESET_LIMIT;
    public static final int MAX_ATTEMPTS_TO_DOWNLOAD_FILE = 3;
    @NotNull
    public static final String TEMP_DIR_NAME = "dynamicpack_f02ffd55_cd44_458a_8d58_e31b11313a53";
    @JvmField
    public static int URLS_BUFFER_SIZE;
    public static final long HTTP_MINIMAL_HEADER_SIZE = 24L;
    @NotNull
    public static final String CLIENT_FILE = "dynamicmcpack.json";
    @NotNull
    public static final String MINECRAFT_META = "pack.mcmeta";
    @NotNull
    private static final String UNKNOWN_PACK_MCMETA;
    @JvmField
    @NotNull
    public static final Gson GSON;
    @NotNull
    private static final Set<String> ALLOWED_HOSTS;

    private Constants() {
    }

    @NotNull
    public final String getVERSION_NAME() {
        return VERSION_NAME;
    }

    public final long getDYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT() {
        return DYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT;
    }

    public final long getMODRINTH_HTTPS_FILE_SIZE_LIMIT() {
        return MODRINTH_HTTPS_FILE_SIZE_LIMIT;
    }

    public final long getMOD_MODTINTH_API_LIMIT() {
        return MOD_MODTINTH_API_LIMIT;
    }

    public final long getGZIP_LIMIT() {
        return GZIP_LIMIT;
    }

    public final long getMOD_FILES_LIMIT() {
        return MOD_FILES_LIMIT;
    }

    public final long getNETWORK_STAT_RESET_LIMIT() {
        return NETWORK_STAT_RESET_LIMIT;
    }

    @NotNull
    public final String getUNKNOWN_PACK_MCMETA() {
        return UNKNOWN_PACK_MCMETA;
    }

    public final void addAllowedHosts$dynamicpack(@Nullable String host, @Nullable Object requester) throws Exception {
        if (host == null || requester == null) {
            Out.INSTANCE.securityWarning("Try to add allowed hosts is failed: null host or requester");
            throw new Exception("Try to add allowed hosts is failed: null host or requester");
        }
        Out.INSTANCE.securityWarning("==== SECURITY WARNING ====");
        Out.INSTANCE.securityWarning("# The DynamicPack mod limits the hosts it can interact with.");
        Out.INSTANCE.securityWarning("# But a certain requester allowed the mod another host to interact with");
        Out.INSTANCE.securityWarning("# ");
        Out.INSTANCE.securityWarning("# Host: " + host);
        Out.INSTANCE.securityWarning("# Requester: " + requester);
        Out.INSTANCE.securityWarning("# StackTrace:");
        Out.INSTANCE.securityStackTrace();
        Out.INSTANCE.securityWarning("# ");
        Out.INSTANCE.securityWarning("===========================");
        ((Collection)ALLOWED_HOSTS).add(host);
    }

    @Nullable
    public final String getUrlHost(@NotNull String url) throws URISyntaxException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new URI(url).getHost();
    }

    public final boolean isUrlHostTrusted(@NotNull String url) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            boolean bl2;
            String string = this.getUrlHost(url);
            if (string == null) {
                return false;
            }
            String host = string;
            if (ALLOWED_HOSTS.contains(host)) {
                bl2 = true;
            } else {
                boolean bl3;
                block10: {
                    Iterable $this$any$iv = ALLOWED_HOSTS;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.endsWith$default((String)host, (String)("." + it), (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    bl2 = true;
                } else {
                    Out.INSTANCE.warn("Check trusted(false): " + host);
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Exception e) {
            throw new IOException("Error while check url for trust", e);
        }
        return bl;
    }

    public final long megabyte(long mb) {
        return 0x100000L * mb;
    }

    @NotNull
    public final String speedToString(long bytesPerSec) {
        return bytesPerSec >= 0x100000L ? bytesPerSec / (long)1024 / (long)1024 + " MiB/s" : (bytesPerSec >= 1024L ? bytesPerSec / (long)1024 + " KiB/s" : bytesPerSec + " B/s");
    }

    @NotNull
    public final String secondsToString(long s) {
        return s > 3600L ? s / (long)3600 + "h" : (s > 60L ? s / (long)60 + "m" : s + "s");
    }

    public final boolean isBlockAllNotTrustedNetworks() {
        return true;
    }

    public final boolean isRelease() {
        return true;
    }

    public final boolean isLocalHostAllowed() {
        return false;
    }

    public final boolean isFileDebugSchemeAllowed() {
        return false;
    }

    public final boolean isHTTPTrafficAllowed() {
        return false;
    }

    public final void debugNetwork(int bytesRead, long total) {
        if (this.isRelease()) {
            return;
        }
    }

    public final boolean isDebugLogs() {
        return DEBUG_LOGS;
    }

    public final boolean isDebugMessageOnWorldJoin() {
        return false;
    }

    static {
        Set set;
        INSTANCE = new Constants();
        VERSION_NAME = "1.2.1+mc1.21.4";
        DYNAMIC_PACK_HTTPS_FILE_SIZE_LIMIT = INSTANCE.megabyte(8L);
        MODRINTH_HTTPS_FILE_SIZE_LIMIT = INSTANCE.megabyte(1024L);
        MOD_MODTINTH_API_LIMIT = INSTANCE.megabyte(8L);
        GZIP_LIMIT = INSTANCE.megabyte(50L);
        MOD_FILES_LIMIT = INSTANCE.megabyte(8L);
        NETWORK_STAT_RESET_LIMIT = INSTANCE.megabyte(3L);
        URLS_BUFFER_SIZE = 1024;
        UNKNOWN_PACK_MCMETA = "{\n  \"pack\": {\n    \"pack_format\": 17,\n    \"description\": \"Unknown DynamicPack resource-pack...\"\n  }\n}";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
        Set $this$ALLOWED_HOSTS_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$ALLOWED_HOSTS_u24lambda_u240.add("modrinth.com");
        $this$ALLOWED_HOSTS_u24lambda_u240.add("github.com");
        $this$ALLOWED_HOSTS_u24lambda_u240.add("github.io");
        $this$ALLOWED_HOSTS_u24lambda_u240.add("githubusercontent.com");
        if (INSTANCE.isLocalHostAllowed()) {
            $this$ALLOWED_HOSTS_u24lambda_u240.add("localhost");
        }
        ALLOWED_HOSTS = CollectionsKt.toMutableSet((Iterable)SetsKt.build((Set)set));
    }
}

