/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorsteam.dynamicpack.util.log;

import com.calculatorsteam.dynamicpack.Constants;
import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0003J\r\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0003R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/calculatorsteam/dynamicpack/util/log/Out;", "", "<init>", "()V", "o", "", "println", "(Ljava/lang/Object;)V", "", "s", "", "e", "error", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "", "isPrintErrorStackTrace", "(Ljava/lang/Throwable;)Z", "warn", "(Ljava/lang/String;)V", "securityWarning", "debug", "securityStackTrace", "init", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "DEFAULT_PREFIX", "Ljava/lang/String;", "ENABLE", "Z", "USE_SOUT", "prefix", "dynamicpack"})
public final class Out {
    @NotNull
    public static final Out INSTANCE = new Out();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String DEFAULT_PREFIX = "[DynamicPack] ";
    @JvmField
    public static boolean ENABLE;
    @JvmField
    public static boolean USE_SOUT;
    @NotNull
    private static String prefix;

    private Out() {
    }

    @JvmStatic
    public static final void println(@Nullable Object o) {
        if (!ENABLE) {
            return;
        }
        if (USE_SOUT) {
            System.out.println((Object)(prefix + o));
        } else {
            LOGGER.info("{}{}", (Object)prefix, o);
        }
    }

    @JvmStatic
    public static final void error(@NotNull String s, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ENABLE) {
            return;
        }
        boolean stacktrace = INSTANCE.isPrintErrorStackTrace(e);
        if (USE_SOUT) {
            System.err.println(prefix + s);
            if (stacktrace) {
                e.printStackTrace();
            }
        } else if (stacktrace) {
            LOGGER.error("{}{}", (Object)prefix, (Object)s, (Object)e);
        } else {
            LOGGER.error("{}{}: {}", (Object)prefix, (Object)s, (Object)e.toString());
        }
    }

    private final boolean isPrintErrorStackTrace(Throwable e) {
        return !(e instanceof FileNotFoundException) && !(e instanceof UnknownHostException);
    }

    public final void warn(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (!ENABLE) {
            return;
        }
        if (USE_SOUT) {
            System.out.println((Object)(prefix + "WARN: " + s));
        } else {
            LOGGER.warn("{}{}", (Object)prefix, (Object)s);
        }
    }

    public final void securityWarning(@NotNull String s) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (USE_SOUT) {
                System.out.println((Object)(DEFAULT_PREFIX + s));
                return;
            }
            Object object2 = this;
            try {
                Out $this$securityWarning_u24lambda_u240 = object2;
                boolean bl = false;
                LOGGER.warn("[DynamicPack] {}", (Object)s);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            System.out.println((Object)(DEFAULT_PREFIX + s));
        }
    }

    public final void debug(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (Constants.INSTANCE.isDebugLogs()) {
            Out.println("DEBUG: " + s);
        }
    }

    public final void securityStackTrace() {
        if (USE_SOUT) {
            System.out.println((Object)"[DynamicPack] Stacktrace");
            new Throwable("StackTrace printer").printStackTrace();
            return;
        }
        LOGGER.error("[DynamicPack] No error. This is stacktrace printer", new Throwable("StackTrace printer"));
    }

    public final void init() {
        if (Constants.INSTANCE.isRelease()) {
            prefix = DEFAULT_PREFIX;
        }
    }

    static {
        Logger logger = LogManager.getLogger((String)"dynamicpack");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        ENABLE = true;
        prefix = "";
    }
}

