package fun.wich;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import java.util.Collection;

public class ChorusCommand implements ModInitializer {
	@Override public void onInitialize() { CommandRegistrationCallback.EVENT.register(ChorusCommand::register); }
	public static void register(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
		dispatcher.register(class_2170.method_9247("chorus")
				.requires(source -> source.method_9259(2))
				.executes(context -> execute(context.getSource(), ImmutableList.of(context.getSource().method_9229()), 1))
				.then(class_2170.method_9244("targets", class_2186.method_9306())
						.executes(context -> execute(context.getSource(), class_2186.method_9317(context, "targets"), 1))
						.then(class_2170.method_9244("chance", FloatArgumentType.floatArg(0, 1))
								.executes(context -> execute(context.getSource(), class_2186.method_9317(context, "targets"), FloatArgumentType.getFloat(context, "chance"))))));
	}
	private static int execute(class_2168 source, Collection<? extends class_1297> targets, float chance) {
		if (chance > 0) {
			int count = 0;
			for (class_1297 entity : targets) {
				if (entity instanceof class_1309 livingEntity) {
					if (livingEntity.method_6051().nextFloat() <= chance) {
						TeleportEntity(livingEntity);
						count++;
					}
				}
			}
			if (targets.size() == 1 && count > 0) source.method_9226(new class_2588("commands.chorus.success.single", targets.iterator().next().method_5476()), true);
			else source.method_9226(new class_2588("commands.chorus.success.multiple", count), true);
		}
		return targets.size();
	}
	public static void TeleportEntity(class_1309 entity) {
		if (entity.method_5770() instanceof class_3218 world) {
			double x = entity.method_23317(), y = entity.method_23318(), z = entity.method_23321();
			for (int i = 0; i < 16; ++i) {
				double g = entity.method_23317() + (entity.method_6051().nextDouble() - 0.5) * 16;
				double h = class_3532.method_15350(entity.method_23318() + (double)(entity.method_6051().nextInt(16) - 8), world.method_31607(), (world.method_31607() + world.method_32819() - 1));
				double j = entity.method_23321() + (entity.method_6051().nextDouble() - 0.5) * 16;
				if (entity.method_5765()) entity.method_5848();
				if (entity.method_6082(g, h, j, true)) {
					class_3414 soundEvent = entity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
					world.method_8465(null, x, y, z, soundEvent, class_3419.field_15248, 1, 1);
					entity.method_5783(soundEvent, 1, 1);
					break;
				}
			}
		}
	}
}