/*
 * Decompiled with CFR 0.152.
 */
package com.example.cringymod;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GirlfriendEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(GirlfriendEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int healCooldown;

    public GirlfriendEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.setTextureVariant(this.f_19796_.m_188503_(41));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }

    public void setTextureVariant(int variant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("TextureVariant", this.getTextureVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("TextureVariant")) {
            this.setTextureVariant(tag.m_128451_("TextureVariant"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.healCooldown > 0) {
            --this.healCooldown;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            ItemStack currentArmor;
            EquipmentSlot armorSlot;
            if (player.m_6144_() && stack.m_41720_() == Items.f_42574_) {
                boolean removedArmor = false;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack armorStack;
                    if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorStack = this.m_6844_(slot)).m_41619_()) continue;
                    this.m_19983_(armorStack.m_41777_());
                    this.m_8061_(slot, ItemStack.f_41583_);
                    removedArmor = true;
                }
                if (removedArmor) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
            }
            if ((armorSlot = this.getSlotForItem(stack)) != null && armorSlot.m_20743_() == EquipmentSlot.Type.ARMOR && ((currentArmor = this.m_6844_(armorSlot)).m_41619_() || player.m_6144_())) {
                if (!currentArmor.m_41619_()) {
                    this.m_19983_(currentArmor.m_41777_());
                }
                ItemStack armorCopy = stack.m_41777_();
                armorCopy.m_41764_(1);
                this.m_8061_(armorSlot, armorCopy);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (!currentArmor.m_41619_() && !player.m_6144_()) {
                        player.m_36356_(currentArmor.m_41777_());
                    }
                }
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && stack.m_41619_()) {
                ItemStack weapon = this.m_21205_();
                if (this.isWeapon(weapon)) {
                    if (!player.m_150110_().f_35937_) {
                        player.m_36356_(weapon.m_41777_());
                    }
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
            } else if (this.isWeapon(stack)) {
                ItemStack weaponCopy = stack.m_41777_();
                weaponCopy.m_41764_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, weaponCopy);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && this.healCooldown <= 0 && stack.m_41614_() && this.m_21223_() < this.m_21233_()) {
            if (!this.m_9236_().f_46443_) {
                float healAmount = stack.m_41720_().m_41473_().m_38744_() * 2;
                this.m_5634_(healAmount);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.healCooldown = 40;
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_21824_() && stack.m_41720_() == Items.f_41940_) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21837_(true);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.SUCCESS;
                }
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && stack.m_41619_() && !player.m_6144_()) {
            this.m_21837_(!this.m_21825_());
            this.m_21839_(this.m_21825_());
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private EquipmentSlot getSlotForItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40402_();
        }
        return null;
    }

    protected void m_5907_() {
        super.m_5907_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemstack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (itemstack = this.m_6844_(slot)).m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.93f : 1.62f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        return null;
    }

    public boolean m_6047_() {
        return this.m_21825_();
    }

    public boolean m_7327_(Entity target) {
        ItemStack weapon;
        boolean attacked = super.m_7327_(target);
        if (attacked && this.isWeapon(weapon = this.m_21205_())) {
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            Item item = weapon.m_41720_();
            if (item instanceof SwordItem) {
                SwordItem sword = (SwordItem)item;
                damage += sword.m_43299_();
            } else {
                item = weapon.m_41720_();
                if (item instanceof AxeItem) {
                    AxeItem axe = (AxeItem)item;
                    damage += axe.m_41008_();
                }
            }
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
            weapon.m_41622_(1, (LivingEntity)this, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return attacked;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Player) && !(target instanceof TamableAnimal)) {
            return true;
        }
        TamableAnimal tamable = (TamableAnimal)target;
        return tamable.m_269323_() != owner;
    }

    private boolean isWeapon(ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem;
    }
}

