/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sashakyotoz.anitexlib.client.particles.types.CircleLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.types.CubeLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.types.SparkleLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.types.WaveLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.types.WispLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.types.models.CircleParticleModel;
import net.sashakyotoz.anitexlib.client.particles.types.models.CubeParticleModel;
import net.sashakyotoz.anitexlib.registries.ModParticleTypes;
import net.sashakyotoz.anitexlib.utils.render.RenderUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AniTexLibClientEvent {
    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("anitexlib", "glowing"), DefaultVertexFormat.f_85815_), shader -> {
            RenderUtils.GLOWING_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("anitexlib", "glowing_particle"), DefaultVertexFormat.f_85813_), shader -> {
            RenderUtils.GLOWING_PARTICLE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("anitexlib", "sprite_particle"), DefaultVertexFormat.f_85813_), shader -> {
            RenderUtils.SPRITE_PARTICLE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("anitexlib", "fluid"), DefaultVertexFormat.f_85813_), shader -> {
            RenderUtils.FLUID_SHADER = shader;
        });
    }

    @SubscribeEvent
    public static void onParticleSetup(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.SPARK_LIKE_PARTICLE.get(), SparkleLikeParticle::provider);
        event.registerSpriteSet((ParticleType)ModParticleTypes.WISP_LIKE_PARTICLE.get(), WispLikeParticle::provider);
        event.registerSpriteSet((ParticleType)ModParticleTypes.WAVE_LIKE_PARTICLE.get(), WaveLikeParticle::provider);
        event.registerSpriteSet((ParticleType)ModParticleTypes.CIRCLE_LIKE_PARTICLE.get(), CircleLikeParticle::provider);
        event.registerSpriteSet((ParticleType)ModParticleTypes.CUBE_LIKE_PARTICLE.get(), CubeLikeParticle::provider);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CircleParticleModel.LAYER_LOCATION, CircleParticleModel::createBodyLayer);
        event.registerLayerDefinition(CubeParticleModel.LAYER_LOCATION, CubeParticleModel::createBodyLayer);
    }
}

