/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.client.particles.parents.options;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import net.sashakyotoz.anitexlib.registries.ModParticleTypes;

public record ColorableParticleOption(String type, float redColor, float greenColor, float blueColor) implements ParticleOptions
{
    public static final Codec<ColorableParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(ColorableParticleOption::type), (App)Codec.FLOAT.fieldOf("redColor").forGetter(ColorableParticleOption::redColor), (App)Codec.FLOAT.fieldOf("greenColor").forGetter(ColorableParticleOption::greenColor), (App)Codec.FLOAT.fieldOf("blueColor").forGetter(ColorableParticleOption::blueColor)).apply((Applicative)instance, ColorableParticleOption::new));
    public static final ParticleOptions.Deserializer<ColorableParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ColorableParticleOption>(){

        public ColorableParticleOption fromCommand(ParticleType<ColorableParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String t = reader.readString();
            reader.expect(' ');
            float f = reader.readFloat();
            reader.expect(' ');
            float f1 = reader.readFloat();
            reader.expect(' ');
            float f2 = reader.readFloat();
            return new ColorableParticleOption(t, f, f1, f2);
        }

        public ColorableParticleOption fromNetwork(ParticleType<ColorableParticleOption> type, FriendlyByteBuf byteBuf) {
            CompoundTag tag = byteBuf.m_130260_();
            String pType = tag.m_128461_("type");
            float r = tag.m_128457_("red");
            float g = tag.m_128457_("green");
            float b = tag.m_128457_("blue");
            return new ColorableParticleOption(pType, r, g, b);
        }
    };

    public ParticleType<?> m_6012_() {
        return switch (this.type) {
            case "sparkle" -> (ParticleType)ModParticleTypes.SPARK_LIKE_PARTICLE.get();
            case "cube" -> (ParticleType)ModParticleTypes.CUBE_LIKE_PARTICLE.get();
            default -> (ParticleType)ModParticleTypes.WISP_LIKE_PARTICLE.get();
        };
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type);
        tag.m_128350_("red", this.redColor);
        tag.m_128350_("green", this.greenColor);
        tag.m_128350_("blue", this.blueColor);
        pBuffer.m_130079_(tag);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.type, Float.valueOf(this.redColor), Float.valueOf(this.greenColor), Float.valueOf(this.blueColor));
    }
}

