/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.client.particles.types;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.sashakyotoz.anitexlib.client.particles.parents.GlowingLikeParticle;
import net.sashakyotoz.anitexlib.client.particles.parents.options.ColorableParticleOption;
import net.sashakyotoz.anitexlib.client.particles.types.models.CubeParticleModel;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.NotNull;

public class CubeLikeParticle
extends GlowingLikeParticle {
    public Triple<Float, Float, Float> END_COLOR;

    @NotNull
    public static CubeProvider provider(SpriteSet spriteSet) {
        return new CubeProvider(spriteSet);
    }

    @Override
    public void m_5989_() {
        this.animateColor();
        super.m_5989_();
    }

    public void animateColor() {
        float lifeProgress = 0.25f;
        if (this.f_107224_ % 5 == 0) {
            lifeProgress = this.f_107223_.m_188501_() + (float)this.f_107224_ > 10.0f ? (float)this.f_107224_ / 100.0f + 0.1f : (float)this.f_107224_ / 10.0f;
            this.f_107663_ += 0.05f;
        }
        float r = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.a).floatValue());
        float g = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.b).floatValue());
        float b = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.c).floatValue());
        this.m_107253_(r, g, b);
    }

    public CubeLikeParticle(ClientLevel level, double x, double y, double z, float vx, float vy, float vz, SpriteSet spriteset) {
        super(level, x, y, z, vx, vy, vz, spriteset);
        this.LIFETIME_VARIANTS[0] = 15;
        this.LIFETIME_VARIANTS[1] = 30;
        this.LIFETIME_VARIANTS[2] = 45;
        this.f_107225_ = this.LIFETIME_VARIANTS[RandomSource.m_216327_().m_216332_(0, this.LIFETIME_VARIANTS.length - 1)];
        this.m_107271_(0.5f);
        this.f_107663_ = 0.5f;
        new CubeRenderSequence(this);
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public static class CubeProvider
    implements ParticleProvider<ColorableParticleOption> {
        private final SpriteSet spriteSet;

        public CubeProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull ColorableParticleOption pType, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CubeLikeParticle particle = new CubeLikeParticle(level, x, y, z, (float)xSpeed, (float)ySpeed, (float)zSpeed, this.spriteSet);
            particle.m_172260_(xSpeed, ySpeed, zSpeed);
            particle.END_COLOR = new Triple((Object)Float.valueOf(pType.redColor()), (Object)Float.valueOf(pType.greenColor()), (Object)Float.valueOf(pType.blueColor()));
            return particle;
        }
    }

    private static class CubeRenderSequence {
        private final CubeLikeParticle particle;
        private final CubeRenderer renderer;

        public CubeRenderSequence(CubeLikeParticle particle) {
            this.particle = particle;
            this.renderer = new CubeRenderer();
        }

        public void start() {
            MinecraftForge.EVENT_BUS.register((Object)this.renderer);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (!this.particle.m_107276_()) {
                this.end();
            }
        }

        private void end() {
            MinecraftForge.EVENT_BUS.unregister((Object)this.renderer);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }

        private class CubeRenderer {
            public final EntityModel<Entity> model = new CubeParticleModel<Entity>(Minecraft.m_91087_().m_167973_().m_171103_(CubeParticleModel.LAYER_LOCATION));

            public CubeRenderer() {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void render(RenderLevelStageEvent event) {
                if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                    VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation("anitexlib", "textures/particle/cube.png")));
                    Vec3 camPos = event.getCamera().m_90583_();
                    double x = Mth.m_14139_((double)event.getPartialTick(), (double)CubeRenderSequence.this.particle.f_107209_, (double)CubeRenderSequence.this.particle.f_107212_) - camPos.m_7096_();
                    double y = Mth.m_14139_((double)event.getPartialTick(), (double)CubeRenderSequence.this.particle.f_107210_, (double)CubeRenderSequence.this.particle.f_107213_) - camPos.m_7098_();
                    double z = Mth.m_14139_((double)event.getPartialTick(), (double)CubeRenderSequence.this.particle.f_107211_, (double)CubeRenderSequence.this.particle.f_107214_) - camPos.m_7094_();
                    event.getPoseStack().m_85836_();
                    event.getPoseStack().m_85837_(x, y, z);
                    event.getPoseStack().m_85841_(CubeRenderSequence.this.particle.f_107663_, CubeRenderSequence.this.particle.f_107663_, CubeRenderSequence.this.particle.f_107663_);
                    this.model.m_7695_(event.getPoseStack(), consumer, CubeRenderSequence.this.particle.m_6355_(event.getPartialTick()), OverlayTexture.f_118083_, CubeRenderSequence.this.particle.f_107227_, CubeRenderSequence.this.particle.f_107228_, CubeRenderSequence.this.particle.f_107229_, CubeRenderSequence.this.particle.f_107230_);
                    event.getPoseStack().m_85849_();
                }
            }
        }
    }
}

