/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.client.particles.types;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.sashakyotoz.anitexlib.client.particles.parents.options.WaveParticleOption;
import net.sashakyotoz.anitexlib.client.particles.types.models.CircleParticleModel;
import net.sashakyotoz.anitexlib.utils.TextureAnimator;
import org.antlr.v4.runtime.misc.Triple;
import org.jetbrains.annotations.NotNull;

public class WaveLikeParticle
extends TextureSheetParticle {
    public Triple<Float, Float, Float> END_COLOR;
    public Integer[] LIFETIME_VARIANTS = new Integer[3];

    public WaveLikeParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteset) {
        super(level, x, y, z, vx, vy, vz);
        this.LIFETIME_VARIANTS[0] = 50;
        this.LIFETIME_VARIANTS[1] = 70;
        this.LIFETIME_VARIANTS[2] = 90;
        this.f_107225_ = this.LIFETIME_VARIANTS[RandomSource.m_216327_().m_188503_(this.LIFETIME_VARIANTS.length)];
        this.f_107226_ = 0.0f;
        this.m_107271_(0.5f);
        new WaveRenderSequence(this).start();
    }

    public void m_5989_() {
        this.animateColor();
        super.m_5989_();
    }

    public void animateColor() {
        float lifeProgress = 0.25f;
        if (this.f_107224_ % 10 == 0) {
            lifeProgress = this.f_107223_.m_188501_();
        }
        float r = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.a).floatValue());
        float g = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.b).floatValue());
        float b = Mth.m_14179_((float)lifeProgress, (float)0.0f, (float)((Float)this.END_COLOR.c).floatValue());
        this.m_107253_(r, g, b);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    @NotNull
    public static WaveLikeParticleProvider provider(SpriteSet spriteSet) {
        return new WaveLikeParticleProvider(spriteSet);
    }

    private static class WaveRenderSequence {
        private final WaveLikeParticle particle;
        private final WaveRenderer renderer;

        public WaveRenderSequence(WaveLikeParticle particle) {
            this.particle = particle;
            this.renderer = new WaveRenderer();
        }

        public void start() {
            MinecraftForge.EVENT_BUS.register((Object)this.renderer);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (!this.particle.m_107276_()) {
                this.end();
            }
        }

        private void end() {
            MinecraftForge.EVENT_BUS.unregister((Object)this.renderer);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }

        private class WaveRenderer {
            public final EntityModel<Entity> model = new CircleParticleModel<Entity>(Minecraft.m_91087_().m_167973_().m_171103_(CircleParticleModel.LAYER_LOCATION));

            public WaveRenderer() {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void render(RenderLevelStageEvent event) {
                if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                    VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)TextureAnimator.getAnimatedTextureByName("anitexlib", "textures/particle/wave_like/", "wave")));
                    Vec3 camPos = event.getCamera().m_90583_();
                    double x = Mth.m_14139_((double)event.getPartialTick(), (double)WaveRenderSequence.this.particle.f_107209_, (double)WaveRenderSequence.this.particle.f_107212_) - camPos.m_7096_();
                    double y = Mth.m_14139_((double)event.getPartialTick(), (double)WaveRenderSequence.this.particle.f_107210_, (double)WaveRenderSequence.this.particle.f_107213_) - camPos.m_7098_() + (double)0.1f;
                    double z = Mth.m_14139_((double)event.getPartialTick(), (double)WaveRenderSequence.this.particle.f_107211_, (double)WaveRenderSequence.this.particle.f_107214_) - camPos.m_7094_();
                    event.getPoseStack().m_85836_();
                    event.getPoseStack().m_85837_(x, y, z);
                    event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(180.0f));
                    event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(WaveRenderSequence.this.particle.f_107231_));
                    event.getPoseStack().m_85841_(WaveRenderSequence.this.particle.f_107663_, WaveRenderSequence.this.particle.f_107663_, WaveRenderSequence.this.particle.f_107663_);
                    this.model.m_7695_(event.getPoseStack(), consumer, WaveRenderSequence.this.particle.m_6355_(event.getPartialTick()), OverlayTexture.f_118083_, WaveRenderSequence.this.particle.f_107227_, WaveRenderSequence.this.particle.f_107228_, WaveRenderSequence.this.particle.f_107229_, WaveRenderSequence.this.particle.f_107230_);
                    event.getPoseStack().m_85849_();
                }
            }
        }
    }

    public static class WaveLikeParticleProvider
    implements ParticleProvider<WaveParticleOption> {
        private final SpriteSet spriteSet;

        public WaveLikeParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(WaveParticleOption pType, @NotNull ClientLevel pLevel, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
            WaveLikeParticle particle = new WaveLikeParticle(pLevel, x, y, z, pXSpeed, pYSpeed, pZSpeed, this.spriteSet);
            particle.m_172260_(pXSpeed, pYSpeed, pZSpeed);
            particle.END_COLOR = new Triple((Object)Float.valueOf(pType.redColor()), (Object)Float.valueOf(pType.greenColor()), (Object)Float.valueOf(pType.blueColor()));
            particle.f_107204_ = pType.roll();
            particle.f_107663_ = pType.scale();
            particle.f_107231_ = pType.roll();
            return particle;
        }
    }
}

