/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;
import net.sashakyotoz.anitexlib.AniTexLib;

public class AnimateOptionsReader {
    protected static final Gson gson = new Gson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static JsonObject getObjectOfTexturesSet(Class<?> mainClass, String modId, String textureFolder, String nameOfTexture) {
        AniTexLib.informUser(String.format("Code gets jsonObject, with modid: %s and name: %s", modId, nameOfTexture), false);
        String path = String.format("%s/assets/%s/textures/%s/%s.png.json", mainClass, modId, textureFolder, nameOfTexture);
        InputStream stream = mainClass.getResourceAsStream("/assets/" + modId + "/textures/" + textureFolder + "/" + nameOfTexture + ".png.json");
        if (stream == null) {
            AniTexLib.informUser(String.format("Impossible to find json with path %s", path), true);
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject != null) {
                JsonObject jsonObject2 = jsonObject;
                return jsonObject2;
            }
            AniTexLib.informUser("JsonObject is null", true);
            return null;
        }
        catch (IOException e) {
            AniTexLib.informUser(String.format("Impossible to read json with path %s/%s", modId, path), true);
            return null;
        }
    }

    protected static JsonObject manageDynamicJsonObject(String modId, String textureFolder, String nameOfTexture, boolean condition, int stopFrame, Integer interval, Integer countOfFrames, UUID entityUUID) {
        AniTexLib.informUser(String.format("Code gets dynamic jsonObject, with modid: %s and name: %s", modId, nameOfTexture), false);
        Path configDir = FMLPaths.GAMEDIR.get().resolve(modId);
        Path CONTROLLERS_PATH = configDir.resolve("animations_controller.json");
        AnimateOptionsReader.createOrUpdateJson(modId, textureFolder, nameOfTexture, condition, stopFrame, interval, countOfFrames, entityUUID);
        try {
            JsonObject jsonObject = (JsonObject)gson.fromJson(new String(Files.readAllBytes(CONTROLLERS_PATH)), JsonObject.class);
            if (jsonObject != null) {
                return jsonObject;
            }
        }
        catch (IOException e) {
            AniTexLib.informUser("Something got wrong with dynamic json parser", true);
        }
        return null;
    }

    public static JsonObject getObjectWithoutUpdate(String modId, UUID entityUUID) {
        try {
            JsonObject mainObject;
            Path CONTROLLERS_PATH;
            Path configDir = FMLPaths.GAMEDIR.get().resolve(modId);
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (Files.exists(CONTROLLERS_PATH = configDir.resolve("animations_controller.json"), new LinkOption[0])) {
                String jsonString = new String(Files.readAllBytes(CONTROLLERS_PATH));
                mainObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
            } else {
                mainObject = new JsonObject();
                mainObject.add("entries", (JsonElement)new JsonArray());
            }
            JsonArray entriesArray = mainObject.getAsJsonArray("entries");
            for (JsonElement entry : entriesArray) {
                JsonObject entryObject = entry.getAsJsonObject();
                if (!entryObject.get("entityUUID").getAsString().equals(entityUUID.toString())) continue;
                return entryObject;
            }
            Files.write(CONTROLLERS_PATH, new Gson().toJson((JsonElement)mainObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            AniTexLib.informUser(String.format("Impossible to get json file with modid: %s, entityUUID: %s", modId, entityUUID), true);
        }
        return null;
    }

    private static void createOrUpdateJson(String modId, String textureFolder, String nameOfTexture, boolean haveToContinueAnimation, int stopFrame, Integer interval, Integer countOfFrames, UUID entityUUID) {
        try {
            JsonObject mainObject;
            Path CONTROLLERS_PATH;
            Path configDir = FMLPaths.GAMEDIR.get().resolve(modId);
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (Files.exists(CONTROLLERS_PATH = configDir.resolve("animations_controller.json"), new LinkOption[0])) {
                String jsonString = new String(Files.readAllBytes(CONTROLLERS_PATH));
                mainObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
            } else {
                mainObject = new JsonObject();
                mainObject.add("entries", (JsonElement)new JsonArray());
            }
            JsonArray entriesArray = mainObject.getAsJsonArray("entries");
            boolean found = false;
            for (JsonElement entry : entriesArray) {
                JsonObject entryObject = entry.getAsJsonObject();
                if (!entryObject.get("entityUUID").getAsString().equals(entityUUID.toString())) continue;
                entryObject.addProperty("haveToContinueAnimation", Boolean.valueOf(haveToContinueAnimation));
                entryObject.addProperty("stopFrame", (Number)stopFrame);
                entryObject.addProperty("interval_of_animation", (Number)interval);
                entryObject.addProperty("amount_of_frames", (Number)countOfFrames);
                entryObject.addProperty("nameOfTexture", nameOfTexture);
                entryObject.addProperty("textureFolder", textureFolder);
                found = true;
                break;
            }
            if (!found) {
                JsonObject newEntry = new JsonObject();
                newEntry.addProperty("entityUUID", entityUUID.toString());
                newEntry.addProperty("haveToContinueAnimation", Boolean.valueOf(haveToContinueAnimation));
                newEntry.addProperty("stopFrame", (Number)stopFrame);
                newEntry.addProperty("interval_of_animation", (Number)interval);
                newEntry.addProperty("amount_of_frames", (Number)countOfFrames);
                newEntry.addProperty("nameOfTexture", nameOfTexture);
                newEntry.addProperty("textureFolder", textureFolder);
                entriesArray.add((JsonElement)newEntry);
            }
            Files.write(CONTROLLERS_PATH, new Gson().toJson((JsonElement)mainObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            AniTexLib.informUser(String.format("Impossible to create/update json file with modid: %s, entityUUID: %s", modId, entityUUID), true);
        }
    }
}

