/*
 * Decompiled with CFR 0.152.
 */
package net.sashakyotoz.anitexlib.utils;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sashakyotoz.anitexlib.AniTexLib;
import net.sashakyotoz.anitexlib.utils.AnimateOptionsReader;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class TextureAnimator {
    public static ArrayList<JsonObject> options = new ArrayList();
    private static final HashMap<String, ResourceLocation> locations = new HashMap();
    private static final HashMap<String, Integer> frameValue = new HashMap();
    private static final Queue<AnimationTask> workQueue = new ConcurrentLinkedQueue<AnimationTask>();

    public static void addEntityToAnimate(Class<?> aClass, String modId, String textureFolder, String nameOfTexture) {
        JsonObject jsonObject = AnimateOptionsReader.getObjectOfTexturesSet(aClass, modId, textureFolder, nameOfTexture);
        if (jsonObject != null) {
            options.add(jsonObject);
            AniTexLib.informUser(String.format("JsonObject with modid: %s and name: %s was added", modId, nameOfTexture), false);
        }
    }

    public static ResourceLocation getAnimatedTextureByName(String modId, String path, String name) {
        if (!options.isEmpty() && options.stream().anyMatch(jsonObject -> jsonObject.get("base_texture_name").getAsString().equals(name))) {
            JsonObject object = options.stream().filter(jsonObject -> jsonObject.get("base_texture_name").getAsString().equals(name)).findFirst().orElseThrow();
            frameValue.putIfAbsent(name, 0);
            locations.putIfAbsent(name, new ResourceLocation(modId, path + name + "0.png"));
            int interval = object.get("interval_of_animation").getAsInt();
            int framesAmount = object.get("amount_of_frames").getAsInt();
            TextureAnimator.queueAnimationTask(name, interval, framesAmount, modId, path);
            return locations.getOrDefault(name, new ResourceLocation(modId, path + name + "0.png"));
        }
        return new ResourceLocation(modId, path + name + "0.png");
    }

    public static ResourceLocation getManagedAnimatedTextureByName(String modId, @Nullable String path, @Nullable String name, @Nullable Boolean toAnimate, @Nullable Integer stopFrame, @Nullable Integer interval, @Nullable Integer countOfFrames, UUID uuid) {
        if (path != null && name != null && toAnimate != null && stopFrame != null && interval != null && countOfFrames != null) {
            AnimateOptionsReader.manageDynamicJsonObject(modId, path, name, toAnimate, stopFrame, interval, countOfFrames, uuid);
            return new ResourceLocation(modId, path + name + "0.png");
        }
        frameValue.putIfAbsent(uuid.toString(), 0);
        JsonObject object = AnimateOptionsReader.getObjectWithoutUpdate(modId, uuid);
        if (object != null) {
            int localStopFrame = object.get("stopFrame").getAsInt();
            int localInterval = object.get("interval_of_animation").getAsInt();
            int framesAmount = object.get("amount_of_frames").getAsInt();
            boolean haveToContinueAnimation = object.get("haveToContinueAnimation").getAsBoolean();
            String localNameOfTexture = object.get("nameOfTexture").getAsString();
            String localTextureFolder = object.get("textureFolder").getAsString();
            locations.putIfAbsent(uuid.toString(), new ResourceLocation(modId, localTextureFolder + localNameOfTexture + frameValue.get(uuid.toString()) + ".png"));
            if (haveToContinueAnimation) {
                TextureAnimator.queueAnimationTask(uuid.toString(), localInterval, localStopFrame > 0 ? localStopFrame : framesAmount, modId, localTextureFolder);
            }
            return locations.getOrDefault(uuid.toString(), new ResourceLocation(modId, localTextureFolder + localNameOfTexture + "0.png"));
        }
        return null;
    }

    public static float simpleAlphaFunction(float intensity, float pAgeInTicks) {
        intensity = intensity <= 0.0f ? 0.1f : intensity;
        return Math.max(0.0f, Mth.m_14089_((float)(pAgeInTicks * intensity)) * 0.5f);
    }

    private static void queueAnimationTask(String name, int interval, int framesAmount, String modId, String path) {
        if (workQueue.stream().noneMatch(task -> task.name.equals(name))) {
            workQueue.add(new AnimationTask(name, interval, framesAmount, modId, path));
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList<AnimationTask> completedTasks = new ArrayList<AnimationTask>();
            for (AnimationTask task : workQueue) {
                --task.remainingTicks;
                if (task.remainingTicks > 0) continue;
                frameValue.put(task.name, frameValue.get(task.name) < task.framesAmount - 1 ? frameValue.get(task.name) + 1 : 0);
                locations.put(task.name, new ResourceLocation(task.modId, task.path + task.name + frameValue.get(task.name) + ".png"));
                task.remainingTicks = task.interval;
                if (frameValue.get(task.name) != task.framesAmount - 1) continue;
                completedTasks.add(task);
            }
            workQueue.removeAll(completedTasks);
        }
    }

    private static class AnimationTask {
        String name;
        int interval;
        int framesAmount;
        String modId;
        String path;
        int remainingTicks;

        AnimationTask(String name, int interval, int framesAmount, String modId, String path) {
            this.name = name;
            this.interval = interval;
            this.framesAmount = framesAmount;
            this.modId = modId;
            this.path = path;
            this.remainingTicks = interval;
        }
    }
}

