/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.client.screen;

import mod.syconn.hero.Constants;
import mod.syconn.hero.client.screen.widgets.HeroButton;
import mod.syconn.hero.util.AbilityUtil;
import mod.syconn.hero.util.HeroTypes;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class HeroSelectorScreen
extends Screen {
    private final ResourceLocation BACKGROUND = Constants.withId("textures/gui/ability_selector.png");
    private final int imageWidth = 176;
    private final int imageHeight = 85;
    private final HeroButton[] buttons = new HeroButton[HeroTypes.values().length];
    private final Player player;
    private HeroTypes selectedType;
    private int leftPos;
    private int topPos;

    public HeroSelectorScreen(Player player) {
        super((Component)Component.m_237115_((String)"hero.ability.screen"));
        this.player = player;
        this.selectedType = AbilityUtil.getHeroType(player);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        for (HeroTypes type : HeroTypes.values) {
            int i = type.ordinal();
            int iconSize = 32;
            this.buttons[i] = new HeroButton(this.leftPos + i * 32 + 6 + i * 7, this.topPos + (75 - iconSize) / 2, iconSize, iconSize, type, type == this.selectedType, type.selectable(this.player), type.getMissingItems(this.player), this::changeHeroType);
            this.m_142416_((GuiEventListener)this.buttons[i]);
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280163_(this.BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void changeHeroType(Button button) {
        HeroButton heroButton;
        if (button instanceof HeroButton && (heroButton = (HeroButton)button).getType().selectable(this.player)) {
            this.buttons[this.selectedType.ordinal()].setSelected(false);
            this.selectedType = AbilityUtil.setHeroType(this.player, heroButton.getType());
            heroButton.setSelected(true);
        }
    }
}

