/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.client.screen.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.syconn.hero.common.data.SuitSettings;
import mod.syconn.hero.core.ModItems;
import mod.syconn.hero.util.AbilityUtil;
import mod.syconn.hero.util.EnergyUtil;
import mod.syconn.hero.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class IronmanOverlay {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");

    public static void renderOverlay(GuiGraphics graphics, float tickDelta) {
        Player player = IronmanOverlay.getCameraPlayer();
        if (player != null && !SuitSettings.from(player).isLifted() && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.MARK_42_HELMET.get())) {
            boolean online = AbilityUtil.canUseIronManPowers(player);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderUtil.blit(graphics, VIGNETTE_LOCATION, 0, 0, -90, 0.0f, 0.0f, graphics.m_280182_(), graphics.m_280206_(), graphics.m_280182_(), graphics.m_280206_(), 1.0f, 1.0f, 127.5f, 0.35f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, "Suit Information", 5, 5, DyeColor.LIGHT_BLUE.m_41071_());
            graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, "Status:", 5, 20, DyeColor.LIGHT_BLUE.m_41071_());
            graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, online ? "Online" : "Offline", 42, 20, online ? DyeColor.GREEN.m_41071_() : DyeColor.RED.m_41071_());
            if (online) {
                SuitSettings settings = SuitSettings.from(player);
                int percentage = EnergyUtil.getSuitPercentage(player);
                int percent_color = percentage >= 75 ? DyeColor.GREEN.m_41071_() : (percentage >= 30 ? DyeColor.YELLOW.m_41071_() : DyeColor.RED.m_41071_());
                graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, "Energy:", 5, 35, DyeColor.LIGHT_BLUE.m_41071_());
                graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, percentage + "%", 47, 35, percent_color);
                graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, "Flight Mode: ", 5, 50, DyeColor.LIGHT_BLUE.m_41071_());
                graphics.m_280488_(IronmanOverlay.minecraft.f_91062_, settings.getFlightMode().name(), 65, 50, percent_color);
                IronmanOverlay.renderPlayerHologram(graphics, 35, graphics.m_280206_() * 2 - 30, 30.0f, (LivingEntity)player);
                IronmanOverlay.renderCombatHotbar(graphics);
            }
            poseStack.m_85849_();
        }
    }

    public static void renderPlayerHologram(GuiGraphics guiGraphics, int x, int y, float scale, LivingEntity entity) {
        float f = (float)Math.atan(0.0);
        float g = (float)Math.atan(0.0);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        quaternionf.mul((Quaternionfc)new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180)));
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        float hurt_level = 5.0f - entity.m_21223_() / entity.m_21233_() * 4.0f;
        guiGraphics.m_280246_(hurt_level, 1.0f, 4.0f, 1.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 50.0f);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        guiGraphics.m_280168_().m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0));
        guiGraphics.m_280262_();
        entityRenderDispatcher.m_114468_(true);
        guiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
    }

    public static void renderCombatHotbar(GuiGraphics graphics) {
    }

    private static Player getCameraPlayer() {
        return !(minecraft.m_91288_() instanceof Player) ? null : (Player)minecraft.m_91288_();
    }
}

