/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.client.screen.widgets;

import java.util.ArrayList;
import java.util.List;
import mod.syconn.hero.Constants;
import mod.syconn.hero.client.screen.widgets.ExtendedButton;
import mod.syconn.hero.util.HeroTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class HeroButton
extends ExtendedButton {
    private final ResourceLocation BACKGROUND = Constants.withId("textures/gui/ability_selector.png");
    private final ResourceLocation ICONS = Constants.withId("textures/gui/hero_icons.png");
    private final HeroTypes type;
    private final boolean selectable;
    private final List<ItemStack> missing;
    private boolean selected;

    public HeroButton(int x, int y, int width, int height, HeroTypes type, boolean selected, boolean selectable, List<ItemStack> missing, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
        this.type = type;
        this.selected = selected;
        this.selectable = selectable;
        this.missing = missing;
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int iconWidth = 128;
        int iconSize = 32;
        guiGraphics.m_280163_(this.BACKGROUND, this.m_252754_(), this.m_252907_(), this.selected ? 208.0f : 176.0f, 8.0f, iconSize, iconSize, 256, 256);
        guiGraphics.m_280163_(this.ICONS, this.m_252754_(), this.m_252907_(), (float)this.type.getRenderX(), (float)this.type.getRenderY(), iconSize, iconSize, iconWidth, iconSize);
        if (this.m_274382_()) {
            guiGraphics.m_280245_(Minecraft.m_91087_().f_91062_, this.generateComponent(), mouseX, mouseY);
        }
    }

    public List<FormattedCharSequence> generateComponent() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        list.add(Component.m_237113_((String)this.type.getOverlayName()).m_130940_(this.selectable ? ChatFormatting.WHITE : ChatFormatting.RED).m_7532_());
        if (!this.selectable) {
            list.add(Component.m_237113_((String)"Missing Required Items").m_7532_());
            for (ItemStack stack : this.missing) {
                list.add(Component.m_237113_((String)("-" + stack.m_41786_().getString() + (String)(stack.m_41613_() > 1 ? " x" + stack.m_41613_() : ""))).m_130940_(ChatFormatting.RED).m_7532_());
            }
        }
        return list;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public HeroTypes getType() {
        return this.type;
    }
}

