/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.common.data;

import mod.syconn.hero.util.AbilityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;

public class SuitSettings {
    private FlightMode flightMode;
    private boolean lifted;

    public SuitSettings(FlightMode flightMode, boolean lifted) {
        this.flightMode = flightMode;
        this.lifted = lifted;
    }

    public SuitSettings(CompoundTag tag) {
        this.flightMode = ((FlightMode[])FlightMode.class.getEnumConstants())[tag.m_128451_("flightMode")];
        this.lifted = tag.m_128471_("lifted");
    }

    public SuitSettings(FriendlyByteBuf buf) {
        this.flightMode = (FlightMode)buf.m_130066_(FlightMode.class);
        this.lifted = buf.readBoolean();
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.flightMode);
        buf.writeBoolean(this.lifted);
    }

    public FlightMode getFlightMode() {
        return this.flightMode;
    }

    public boolean isLifted() {
        return this.lifted;
    }

    public SuitSettings flipHelmet() {
        this.lifted = !this.lifted;
        return this;
    }

    public void cycleMode() {
        this.flightMode = switch (this.flightMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> FlightMode.FLY;
            case 1 -> FlightMode.WALK;
            case 2 -> FlightMode.HOVER;
        };
    }

    public CompoundTag writeTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("flightMode", this.flightMode.ordinal());
        tag.m_128379_("lifted", this.lifted);
        return tag;
    }

    public static SuitSettings instance() {
        return new SuitSettings(FlightMode.WALK, false);
    }

    public static SuitSettings from(Player player) {
        SuitSettings settings = SuitSettings.instance();
        if (AbilityUtil.canInteractWithIronManHelmet(player)) {
            if (player.m_6844_(EquipmentSlot.HEAD).m_41784_().m_128441_("settings")) {
                return new SuitSettings((CompoundTag)player.m_6844_(EquipmentSlot.HEAD).m_41784_().m_128423_("settings"));
            }
            player.m_6844_(EquipmentSlot.HEAD).m_41784_().m_128365_("settings", (Tag)settings.writeTag());
        }
        return settings;
    }

    public static void set(Player player, SuitSettings settings) {
        player.m_6844_(EquipmentSlot.HEAD).m_41784_().m_128365_("settings", (Tag)settings.writeTag());
    }

    public static enum FlightMode {
        WALK,
        HOVER,
        FLY;

    }
}

