/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.common.entity;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import mod.syconn.hero.core.ModDamageTypes;
import mod.syconn.hero.core.ModEntities;
import mod.syconn.hero.core.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownMjolnir
extends AbstractArrow
implements EntitySpawnExtension {
    private float thrownAngle = 0.0f;
    private ItemStack mjonirItem = new ItemStack((ItemLike)ModItems.MJOLNIR.get());
    private boolean dealtDamage;
    public int clientReturnTicks;

    public ThrownMjolnir(EntityType<? extends ThrownMjolnir> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownMjolnir(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super(ModEntities.MJOLNIR.get(), pShooter, pLevel);
        this.mjonirItem = pStack.m_41777_();
        this.thrownAngle = pShooter.f_20885_;
    }

    public void m_8119_() {
        if (this.m_6060_()) {
            this.m_7311_(0);
        }
        if (this.f_36704_ > 3) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        int speed = 3;
        if ((this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (this.m_9236_() instanceof ServerLevel && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)speed, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)speed;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientReturnTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientReturnTicks;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_19749_();
        return entity != null && entity.m_6084_() && (!(entity instanceof ServerPlayer) || !entity.m_5833_());
    }

    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        float f = 8.0f;
        Entity entity2 = this.m_19749_();
        DamageSource damagesource = ModDamageTypes.mjolnir((Entity)this, (Entity)(entity2 == null ? this : entity2));
        this.dealtDamage = true;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        ThrownMjolnir.strikeLightning(this.m_9236_(), pResult.m_82443_().m_20097_());
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        ThrownMjolnir.strikeLightning(this.m_9236_(), pResult.m_82425_());
    }

    public static void strikeLightning(Level level, BlockPos point) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        if (lightningbolt != null) {
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)point));
            lightningbolt.m_20874_(false);
            level.m_7967_((Entity)lightningbolt);
        }
    }

    protected ItemStack m_7941_() {
        return this.mjonirItem.m_41777_();
    }

    public ItemStack getMjonirItem() {
        return this.mjonirItem;
    }

    public float getThrownAngle() {
        return this.thrownAngle;
    }

    protected boolean m_142470_(Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.writeFloat(this.thrownAngle);
        buf.writeInt(this.m_19749_() == null ? 0 : this.m_19749_().m_19879_());
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.thrownAngle = buf.readFloat();
        Entity entity = this.m_9236_().m_6815_(buf.readInt());
        if (entity != null) {
            this.m_5602_(entity);
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

