/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.mixin;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import mod.syconn.hero.common.data.SuitSettings;
import mod.syconn.hero.common.item.IronmanArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> {
    @Unique
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();

    @Inject(at={@At(value="HEAD")}, method={"renderArmorPiece"}, cancellable=true)
    public void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, T livingEntity, EquipmentSlot slot, int packedLight, A model, CallbackInfo ci) {
        ItemStack itemStack = livingEntity.m_6844_(slot);
        Item bl = itemStack.m_41720_();
        if (livingEntity instanceof Player) {
            IronmanArmorItem armorItem;
            Player player = (Player)livingEntity;
            if (bl instanceof IronmanArmorItem && (armorItem = (IronmanArmorItem)bl).m_40402_() == slot && slot == EquipmentSlot.HEAD) {
                ((HumanoidModel)((HumanoidArmorLayer)this).m_117386_()).m_102872_(model);
                this.heroCore$setPartVisibility(model, slot);
                this.heroCore$renderModel(poseStack, buffer, packedLight, armorItem, model, SuitSettings.from(player).isLifted());
                ci.cancel();
            }
        }
    }

    @Unique
    protected void heroCore$setPartVisibility(A model, EquipmentSlot slot) {
        model.m_8009_(false);
        switch (slot) {
            case HEAD: {
                ((HumanoidModel)model).f_102808_.f_104207_ = true;
                ((HumanoidModel)model).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102811_.f_104207_ = true;
                ((HumanoidModel)model).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)model).f_102810_.f_104207_ = true;
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)model).f_102813_.f_104207_ = true;
                ((HumanoidModel)model).f_102814_.f_104207_ = true;
            }
        }
    }

    @Unique
    private void heroCore$renderModel(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ArmorItem armorItem, A model, boolean lifted) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110431_((ResourceLocation)this.heroCore$getArmorLocation(armorItem, lifted)));
        model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Unique
    private ResourceLocation heroCore$getArmorLocation(ArmorItem armorItem, boolean lifted) {
        return ARMOR_LOCATION_CACHE.computeIfAbsent("textures/models/armor/" + armorItem.m_40401_().m_6082_() + "_layer_1" + (lifted ? "_lifted" : "") + ".png", ResourceLocation::new);
    }
}

