/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.mixin;

import java.util.function.Function;
import mod.syconn.hero.util.HeroTypes;
import mod.syconn.hero.util.PersistentData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerPersistentDataMixin
implements PersistentData {
    @Unique
    private CompoundTag persistentData;

    @Override
    public CompoundTag getPersistentData() {
        if (this.persistentData == null) {
            this.persistentData = HeroTypes.NONE.write(new CompoundTag());
        }
        return this.persistentData;
    }

    @Override
    public void syncPersistentData(CompoundTag tag) {
        this.persistentData = tag;
    }

    @Override
    public void updatePersistentData(Player player, Function<CompoundTag, CompoundTag> function) {
        this.persistentData = function.apply(this.getPersistentData());
        this.sync(this, player);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    protected void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        if (this.persistentData != null) {
            compound.m_128365_("hero:persistentData", (Tag)this.persistentData);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    protected void readAdditionalSaveData(CompoundTag nbt, CallbackInfo info) {
        if (nbt.m_128441_("hero:persistentData")) {
            this.persistentData = nbt.m_128469_("hero:persistentData");
        }
    }
}

