/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.util;

import java.util.ArrayList;
import java.util.List;
import mod.syconn.hero.core.ModItems;
import mod.syconn.hero.util.HeroTypes;
import mod.syconn.hero.util.PersistentData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class AbilityUtil {
    public static boolean canUseIronManPowers(Player player) {
        NonNullList inv = player.m_150109_().f_35975_;
        return ((ItemStack)inv.get(0)).m_150930_((Item)ModItems.MARK_42_BOOTS.get()) && ((ItemStack)inv.get(1)).m_150930_((Item)ModItems.MARK_42_LEGGINGS.get()) && ((ItemStack)inv.get(2)).m_150930_((Item)ModItems.MARK_42_CHESTPLATE.get()) && ((ItemStack)inv.get(3)).m_150930_((Item)ModItems.MARK_42_HELMET.get());
    }

    public static boolean canInteractWithIronManHelmet(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.MARK_42_HELMET.get());
    }

    public static List<ItemStack> missingIronManItems(Player player) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        NonNullList inv = player.m_150109_().f_35975_;
        if (!((ItemStack)inv.get(0)).m_150930_((Item)ModItems.MARK_42_BOOTS.get())) {
            missing.add(new ItemStack((ItemLike)ModItems.MARK_42_BOOTS.get()));
        }
        if (!((ItemStack)inv.get(1)).m_150930_((Item)ModItems.MARK_42_LEGGINGS.get())) {
            missing.add(new ItemStack((ItemLike)ModItems.MARK_42_LEGGINGS.get()));
        }
        if (!((ItemStack)inv.get(2)).m_150930_((Item)ModItems.MARK_42_CHESTPLATE.get())) {
            missing.add(new ItemStack((ItemLike)ModItems.MARK_42_CHESTPLATE.get()));
        }
        if (!((ItemStack)inv.get(3)).m_150930_((Item)ModItems.MARK_42_HELMET.get())) {
            missing.add(new ItemStack((ItemLike)ModItems.MARK_42_HELMET.get()));
        }
        return missing;
    }

    public static boolean canUseThorPowers(Player player) {
        return AbilityUtil.getHolding(player).m_150930_((Item)ModItems.MJOLNIR.get());
    }

    public static boolean canSelectThorPowers(Player player) {
        return player.m_150109_().m_36063_(new ItemStack((ItemLike)ModItems.MJOLNIR.get()));
    }

    public static List<ItemStack> missingThorItems(Player player) {
        return AbilityUtil.canSelectThorPowers(player) ? List.of() : List.of(new ItemStack((ItemLike)ModItems.MJOLNIR.get()));
    }

    public static ItemStack getHolding(Player player) {
        return player.m_6844_(EquipmentSlot.MAINHAND).m_41619_() ? player.m_21120_(InteractionHand.OFF_HAND) : player.m_6844_(EquipmentSlot.MAINHAND);
    }

    public static HeroTypes getHeroType(Player player) {
        return HeroTypes.read(((PersistentData)player).getPersistentData());
    }

    public static HeroTypes setHeroType(Player player, HeroTypes heroType) {
        ((PersistentData)player).updatePersistentData(player, heroType::write);
        return heroType;
    }

    public static boolean useSpecificPower(Player player, HeroTypes power) {
        return AbilityUtil.canUseOrUpdatePower(player) && AbilityUtil.getHeroType(player) == power;
    }

    public static boolean canUseOrUpdatePower(Player player) {
        HeroTypes selectedPower = AbilityUtil.getHeroType(player);
        if (selectedPower.canUse(player)) {
            return true;
        }
        if (!selectedPower.selectable(player)) {
            player.m_5661_((Component)Component.m_237113_((String)"Missing the Required Gear for the Power").m_130940_(ChatFormatting.GOLD), true);
            AbilityUtil.setHeroType(player, HeroTypes.NONE);
        }
        return false;
    }

    public static EntityHitResult playerRaycast(Player player, int distance) {
        Vec3 position = player.m_20299_(1.0f);
        Vec3 view = player.m_20252_(1.0f);
        Vec3 looking = position.m_82520_(view.f_82479_ * (double)(distance *= 16), view.f_82480_ * (double)distance, view.f_82481_ * (double)distance);
        AABB aABB = player.m_20191_().m_82369_(looking.m_82490_((double)distance)).m_82377_(1.0, 1.0, 1.0);
        return ProjectileUtil.m_37287_((Entity)player, (Vec3)position, (Vec3)looking, (AABB)aABB, entity -> !entity.m_5833_(), (double)distance);
    }
}

