/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.util;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;

public class AnimationUtil {
    public static ModifierLayer<IAnimation> getAnimator(AbstractClientPlayer player) {
        return (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player).get(new ResourceLocation("hero", "animation"));
    }

    public static void play(AbstractClientPlayer player, String animation) {
        ModifierLayer<IAnimation> animator = AnimationUtil.getAnimator(player);
        if (animator != null && AnimationUtil.valid(animation)) {
            animator.setAnimation((IAnimation)new KeyframeAnimationPlayer(Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("hero", animation)))));
        }
    }

    public static void play(AbstractClientPlayer player, String animation, int delay) {
        ModifierLayer<IAnimation> animator = AnimationUtil.getAnimator(player);
        if (animator != null && AnimationUtil.valid(animation)) {
            animator.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)delay, (Ease)Ease.CONSTANT), (IAnimation)new KeyframeAnimationPlayer(Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("hero", animation)))));
        }
    }

    public static void play(AbstractClientPlayer player, String animation, int delay, Ease ease) {
        ModifierLayer<IAnimation> animator = AnimationUtil.getAnimator(player);
        if (animator != null && AnimationUtil.valid(animation)) {
            animator.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)delay, (Ease)ease), (IAnimation)new KeyframeAnimationPlayer(Objects.requireNonNull(PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("hero", animation)))));
        }
    }

    public static void stop(AbstractClientPlayer player) {
        ModifierLayer<IAnimation> animator = AnimationUtil.getAnimator(player);
        if (animator != null) {
            animator.setAnimation(null);
        }
    }

    public static boolean isAnimated(AbstractClientPlayer player) {
        return AnimationUtil.getAnimator(player).isActive();
    }

    private static boolean valid(String animation) {
        return PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("hero", animation)) != null;
    }
}

