/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.util;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EnergyUtil {
    private static final String ENERGY = "energy";
    private static final String MAX = "max_energy";

    public static int getEnergy(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(ENERGY)) {
            stack.m_41784_().m_128405_(ENERGY, EnergyUtil.getMax(stack));
        }
        return stack.m_41784_().m_128451_(ENERGY);
    }

    public static int getEnergy(Player player, InteractionHand hand) {
        return EnergyUtil.getEnergy(player.m_21120_(hand));
    }

    public static int getMax(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(MAX)) {
            stack.m_41784_().m_128405_(MAX, 100);
        }
        return stack.m_41784_().m_128451_(MAX);
    }

    public static int getMax(Player player, InteractionHand hand) {
        return EnergyUtil.getEnergy(player.m_21120_(hand));
    }

    public static int modifyEnergy(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_(ENERGY, EnergyUtil.getEnergy(stack) + amount);
        return EnergyUtil.getEnergy(stack);
    }

    public static int modifyEnergy(Player player, InteractionHand hand, int amount) {
        return EnergyUtil.modifyEnergy(player.m_21120_(hand), amount);
    }

    public static void setMax(ItemStack stack, int max) {
        stack.m_41784_().m_128405_(MAX, max);
    }

    public static void setMax(Player player, InteractionHand hand, int max) {
        EnergyUtil.setMax(player.m_21120_(hand), max);
    }

    public static void lowerSuitEnergy(Player player) {
        EnergyUtil.modifyEnergy(player.m_6844_(EquipmentSlot.HEAD), -1);
        EnergyUtil.modifyEnergy(player.m_6844_(EquipmentSlot.CHEST), -1);
        EnergyUtil.modifyEnergy(player.m_6844_(EquipmentSlot.LEGS), -1);
        EnergyUtil.modifyEnergy(player.m_6844_(EquipmentSlot.FEET), -1);
    }

    public static int getSuitEnergy(Player player) {
        return EnergyUtil.getEnergy(player.m_6844_(EquipmentSlot.HEAD)) + EnergyUtil.getEnergy(player.m_6844_(EquipmentSlot.CHEST)) + EnergyUtil.getEnergy(player.m_6844_(EquipmentSlot.LEGS)) + EnergyUtil.getEnergy(player.m_6844_(EquipmentSlot.FEET));
    }

    public static int getSuitEnergyMax(Player player) {
        return EnergyUtil.getMax(player.m_6844_(EquipmentSlot.HEAD)) + EnergyUtil.getMax(player.m_6844_(EquipmentSlot.CHEST)) + EnergyUtil.getMax(player.m_6844_(EquipmentSlot.LEGS)) + EnergyUtil.getMax(player.m_6844_(EquipmentSlot.FEET));
    }

    public static int getSuitPercentage(Player player) {
        return (int)((float)EnergyUtil.getSuitEnergy(player) / (float)EnergyUtil.getSuitEnergyMax(player) * 100.0f);
    }
}

