/*
 * Decompiled with CFR 0.152.
 */
package mod.syconn.hero.util;

import java.util.List;
import java.util.function.Function;
import mod.syconn.hero.util.AbilityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public enum HeroTypes implements StringRepresentable
{
    NONE("No Powers", 64, 0, player -> true, player -> true, player -> List.of()),
    IRON_MAN("Fight with Iron Man's Suit", 0, 0, AbilityUtil::canUseIronManPowers, AbilityUtil::canUseIronManPowers, AbilityUtil::missingIronManItems),
    THOR("Wield Thor's Lightning", 32, 0, AbilityUtil::canUseThorPowers, AbilityUtil::canSelectThorPowers, AbilityUtil::missingThorItems);

    private final String name;
    private final int renderX;
    private final int renderY;
    private final Function<Player, Boolean> usable;
    private final Function<Player, Boolean> selectable;
    private final Function<Player, List<ItemStack>> missing;
    public static final HeroTypes[] values;

    private HeroTypes(String name, int renderX, int renderY, Function<Player, Boolean> usable, Function<Player, Boolean> selectable, Function<Player, List<ItemStack>> missing) {
        this.name = name;
        this.renderX = renderX;
        this.renderY = renderY;
        this.usable = usable;
        this.selectable = selectable;
        this.missing = missing;
    }

    public String getOverlayName() {
        return this.name;
    }

    public int getRenderX() {
        return this.renderX;
    }

    public int getRenderY() {
        return this.renderY;
    }

    public boolean canUse(Player player) {
        return this.usable.apply(player);
    }

    public boolean selectable(Player player) {
        return this.selectable.apply(player);
    }

    public List<ItemStack> getMissingItems(Player player) {
        return this.missing.apply(player);
    }

    public String m_7912_() {
        return this.name().toLowerCase();
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128405_("hero:power", this.ordinal());
        return tag;
    }

    public static HeroTypes read(CompoundTag tag) {
        for (HeroTypes heroType : values) {
            if (heroType.ordinal() != tag.m_128451_("hero:power")) continue;
            return heroType;
        }
        return NONE;
    }

    static {
        values = HeroTypes.values();
    }
}

