/*
 * Decompiled with CFR 0.152.
 */
package net.theblueshark.villager_team_cure.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_4136;
import net.minecraft.class_4151;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import net.theblueshark.villager_team_cure.ModAccessors.CuredAccessor;
import net.theblueshark.villager_team_cure.TeamCure;
import net.theblueshark.villager_team_cure.util.ModConfigModel;
import net.theblueshark.villager_team_cure.util.ModDataComponents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1646.class})
public abstract class VillagerMixin
implements CuredAccessor {
    @Shadow
    @Final
    private class_4136 field_18534;
    @Unique
    private final Map<UUID, String> curedByPlayersWithTeams = new HashMap<UUID, String>();

    @Shadow
    protected abstract <T> boolean method_66654(class_9331<T> var1, T var2);

    @Override
    public void addCuringPlayer(class_1657 player) {
        String teamName = player.method_5781() != null ? player.method_5781().method_1197() : "";
        this.curedByPlayersWithTeams.put(player.method_5667(), teamName);
        this.method_66654(ModDataComponents.CURED_TEAMS, this.curedByPlayersWithTeams);
    }

    @Override
    public Map<UUID, String> getCuringPlayers() {
        return this.curedByPlayersWithTeams;
    }

    @Override
    @Unique
    public boolean wasCuredByTeam(class_1657 player) {
        if (player.method_5781() == null) {
            return false;
        }
        String playerTeamName = player.method_5781().method_1197();
        return this.curedByPlayersWithTeams.values().stream().filter(name -> !name.isEmpty()).anyMatch(name -> name.equals(playerTeamName));
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void saveCuredPlayersToNBT(class_11372 valueOutput, CallbackInfo ci) {
        if (!this.curedByPlayersWithTeams.isEmpty()) {
            valueOutput.method_71468("CuredByPlayersWithTeams", ModDataComponents.CURED_TEAMS_CODEC, this.curedByPlayersWithTeams);
        }
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void loadCuredPlayersFromNBT(class_11368 valueInput, CallbackInfo ci) {
        this.curedByPlayersWithTeams.clear();
        valueInput.method_71426("CuredByPlayersWithTeams", ModDataComponents.CURED_TEAMS_CODEC).ifPresent(this.curedByPlayersWithTeams::putAll);
    }

    @Inject(method={"method_66649(Lnet/minecraft/class_9473;)V"}, at={@At(value="TAIL")})
    private void applyCuredTeamsComponent(class_9473 getter, CallbackInfo ci) {
        this.method_66654(ModDataComponents.CURED_TEAMS, this.curedByPlayersWithTeams);
    }

    @Inject(method={"method_18870(Lnet/minecraft/class_4151;Lnet/minecraft/class_1297;)V"}, at={@At(value="HEAD")})
    private void onReputationEventFromMixin(class_4151 reputationEventType, class_1297 entity, CallbackInfo ci) {
        if (reputationEventType == class_4151.field_18474 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.addCuringPlayer(player);
        }
    }

    @Inject(method={"method_20594(Lnet/minecraft/class_1657;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyGetPlayerReputation(class_1657 player, CallbackInfoReturnable<Integer> cir) {
        int baseReputation = this.field_18534.method_19073(player.method_5667(), gossipType -> true);
        if (!(this.curedByPlayersWithTeams.isEmpty() || this.curedByPlayersWithTeams.containsKey(player.method_5667()) || TeamCure.CONFIG.dissableMod())) {
            if (TeamCure.CONFIG.mode() == ModConfigModel.Choices.team && this.wasCuredByTeam(player)) {
                baseReputation += 100;
            }
            if (TeamCure.CONFIG.mode() == ModConfigModel.Choices.everyone) {
                baseReputation += 100;
            }
        }
        cir.setReturnValue((Object)baseReputation);
    }
}

