/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item;

import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnderBackpackItem
extends Item {
    public EnderBackpackItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        PlayerEnderChestContainer playerEnderChestContainer = player.getEnderChestInventory();
        final ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.playSound(player);
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerx) -> new ChestMenu(this, MenuType.GENERIC_9x3, i, inventory, (Container)playerEnderChestContainer, 3){

            public void clicked(int slotId, int button, ClickType clickType, Player player) {
                if (slotId > -1 && this.getSlot(slotId).getItem().equals(stack)) {
                    return;
                }
                super.clicked(slotId, button, clickType, player);
            }
        }, (Component)Component.translatable((String)"container.enderchest")));
        player.awardStat(Stats.OPEN_ENDERCHEST);
        return InteractionResult.CONSUME;
    }

    private void playSound(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvents.ENDER_CHEST_OPEN), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 0.5f, 1.0f, player.level().getRandom().nextLong()));
        }
    }
}

