/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item.backpack;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class BackpackContainer
extends SimpleContainer {
    private final ItemStack stack;
    private final BackpackSize size;

    public BackpackContainer(ItemStack stack, BackpackSize size) {
        super(BackpackContainer.sizeToInt(size));
        this.stack = stack;
        this.size = size;
        ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        contents.copyInto(this.getItems());
    }

    public static int sizeToInt(BackpackSize size) {
        return switch (size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 18;
            case 1 -> 27;
            case 2 -> 36;
            case 3 -> 45;
            case 4 -> 54;
        };
    }

    public MenuType<ChestMenu> getMenuType() {
        return BackpackContainer.sizeToChestMenu(this.size);
    }

    private static MenuType<ChestMenu> sizeToChestMenu(BackpackSize size) {
        return switch (size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MenuType.GENERIC_9x2;
            case 1 -> MenuType.GENERIC_9x3;
            case 2 -> MenuType.GENERIC_9x4;
            case 3 -> MenuType.GENERIC_9x5;
            case 4 -> MenuType.GENERIC_9x6;
        };
    }

    public int rows() {
        return switch (this.size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 2;
            case 1 -> 3;
            case 2 -> 4;
            case 3 -> 5;
            case 4 -> 6;
        };
    }

    public void setChanged() {
        super.setChanged();
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.getItems()));
    }

    public static enum BackpackSize {
        TWO_ROWS,
        THREE_ROWS,
        FOUR_ROWS,
        FIVE_ROWS,
        SIX_ROWS;

    }
}

