/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item.backpack;

import com.iamkaf.mochila.item.backpack.BackpackUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BackpackMenu
extends ChestMenu {
    public BackpackMenu(MenuType<?> type, int containerId, Inventory playerInventory, Container container, int rows) {
        super(type, containerId, playerInventory, container, rows);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId > -1) {
            Slot slot = (Slot)this.slots.get(slotId);
            if (clickType.equals((Object)ClickType.SWAP) && BackpackUtils.isBlacklistedItem(player.getOffhandItem().getItem())) {
                return;
            }
            if (slot.hasItem() && this.slotContainsBlacklistedItem(slotId)) {
                return;
            }
        }
        super.clicked(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem() && this.slotContainsBlacklistedItem(index)) {
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(player, index);
    }

    private boolean slotContainsBlacklistedItem(int slotId) {
        Item theItem = this.getSlot(slotId).getItem().getItem();
        return BackpackUtils.isBlacklistedItem(theItem);
    }
}

