/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item.backpack;

import com.iamkaf.mochila.item.BackpackItem;
import com.iamkaf.mochila.registry.Items;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackUtils {
    public static Item getBackpackByColor(ItemStack backpack, DyeColor color) {
        Tier tier = BackpackUtils.determineTier(backpack);
        return BackpackUtils.getBackpackByTierAndColor(tier, color);
    }

    @Nullable
    public static Tier getNextTier(Tier tier) {
        return switch (tier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Tier.IRON;
            case 1 -> Tier.GOLD;
            case 2 -> Tier.DIAMOND;
            case 3 -> Tier.NETHERITE;
            case 4 -> null;
        };
    }

    public static Item getBackpackByTierAndColor(Tier tier, @Nullable DyeColor color) {
        return switch (tier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DyeColor var2_2 = color;
                int var3_7 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "LIGHT_GRAY", "GRAY", "BLACK", "BROWN", "RED", "YELLOW", "ORANGE", "LIME", "GREEN", "CYAN", "LIGHT_BLUE", "BLUE", "PURPLE", "MAGENTA", "PINK"}, (DyeColor)var2_2, var3_7)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Items.WHITE_LEATHER_BACKPACK.get();
                    }
                    case 1: {
                        yield Items.LIGHT_GRAY_LEATHER_BACKPACK.get();
                    }
                    case 2: {
                        yield Items.GRAY_LEATHER_BACKPACK.get();
                    }
                    case 3: {
                        yield Items.BLACK_LEATHER_BACKPACK.get();
                    }
                    case 4: {
                        yield Items.BROWN_LEATHER_BACKPACK.get();
                    }
                    case 5: {
                        yield Items.RED_LEATHER_BACKPACK.get();
                    }
                    case 6: {
                        yield Items.YELLOW_LEATHER_BACKPACK.get();
                    }
                    case 7: {
                        yield Items.ORANGE_LEATHER_BACKPACK.get();
                    }
                    case 8: {
                        yield Items.LIME_LEATHER_BACKPACK.get();
                    }
                    case 9: {
                        yield Items.GREEN_LEATHER_BACKPACK.get();
                    }
                    case 10: {
                        yield Items.CYAN_LEATHER_BACKPACK.get();
                    }
                    case 11: {
                        yield Items.LIGHT_BLUE_LEATHER_BACKPACK.get();
                    }
                    case 12: {
                        yield Items.BLUE_LEATHER_BACKPACK.get();
                    }
                    case 13: {
                        yield Items.PURPLE_LEATHER_BACKPACK.get();
                    }
                    case 14: {
                        yield Items.MAGENTA_LEATHER_BACKPACK.get();
                    }
                    case 15: {
                        yield Items.PINK_LEATHER_BACKPACK.get();
                    }
                    case -1: 
                }
                yield Items.LEATHER_BACKPACK.get();
            }
            case 1 -> {
                DyeColor var2_3 = color;
                int var3_8 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "LIGHT_GRAY", "GRAY", "BLACK", "BROWN", "RED", "YELLOW", "ORANGE", "LIME", "GREEN", "CYAN", "LIGHT_BLUE", "BLUE", "PURPLE", "MAGENTA", "PINK"}, (DyeColor)var2_3, var3_8)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Items.WHITE_IRON_BACKPACK.get();
                    }
                    case 1: {
                        yield Items.LIGHT_GRAY_IRON_BACKPACK.get();
                    }
                    case 2: {
                        yield Items.GRAY_IRON_BACKPACK.get();
                    }
                    case 3: {
                        yield Items.BLACK_IRON_BACKPACK.get();
                    }
                    case 4: {
                        yield Items.BROWN_IRON_BACKPACK.get();
                    }
                    case 5: {
                        yield Items.RED_IRON_BACKPACK.get();
                    }
                    case 6: {
                        yield Items.YELLOW_IRON_BACKPACK.get();
                    }
                    case 7: {
                        yield Items.ORANGE_IRON_BACKPACK.get();
                    }
                    case 8: {
                        yield Items.LIME_IRON_BACKPACK.get();
                    }
                    case 9: {
                        yield Items.GREEN_IRON_BACKPACK.get();
                    }
                    case 10: {
                        yield Items.CYAN_IRON_BACKPACK.get();
                    }
                    case 11: {
                        yield Items.LIGHT_BLUE_IRON_BACKPACK.get();
                    }
                    case 12: {
                        yield Items.BLUE_IRON_BACKPACK.get();
                    }
                    case 13: {
                        yield Items.PURPLE_IRON_BACKPACK.get();
                    }
                    case 14: {
                        yield Items.MAGENTA_IRON_BACKPACK.get();
                    }
                    case 15: {
                        yield Items.PINK_IRON_BACKPACK.get();
                    }
                    case -1: 
                }
                yield Items.IRON_BACKPACK.get();
            }
            case 2 -> {
                DyeColor var2_4 = color;
                int var3_9 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "LIGHT_GRAY", "GRAY", "BLACK", "BROWN", "RED", "YELLOW", "ORANGE", "LIME", "GREEN", "CYAN", "LIGHT_BLUE", "BLUE", "PURPLE", "MAGENTA", "PINK"}, (DyeColor)var2_4, var3_9)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Items.WHITE_GOLD_BACKPACK.get();
                    }
                    case 1: {
                        yield Items.LIGHT_GRAY_GOLD_BACKPACK.get();
                    }
                    case 2: {
                        yield Items.GRAY_GOLD_BACKPACK.get();
                    }
                    case 3: {
                        yield Items.BLACK_GOLD_BACKPACK.get();
                    }
                    case 4: {
                        yield Items.BROWN_GOLD_BACKPACK.get();
                    }
                    case 5: {
                        yield Items.RED_GOLD_BACKPACK.get();
                    }
                    case 6: {
                        yield Items.YELLOW_GOLD_BACKPACK.get();
                    }
                    case 7: {
                        yield Items.ORANGE_GOLD_BACKPACK.get();
                    }
                    case 8: {
                        yield Items.LIME_GOLD_BACKPACK.get();
                    }
                    case 9: {
                        yield Items.GREEN_GOLD_BACKPACK.get();
                    }
                    case 10: {
                        yield Items.CYAN_GOLD_BACKPACK.get();
                    }
                    case 11: {
                        yield Items.LIGHT_BLUE_GOLD_BACKPACK.get();
                    }
                    case 12: {
                        yield Items.BLUE_GOLD_BACKPACK.get();
                    }
                    case 13: {
                        yield Items.PURPLE_GOLD_BACKPACK.get();
                    }
                    case 14: {
                        yield Items.MAGENTA_GOLD_BACKPACK.get();
                    }
                    case 15: {
                        yield Items.PINK_GOLD_BACKPACK.get();
                    }
                    case -1: 
                }
                yield Items.GOLD_BACKPACK.get();
            }
            case 3 -> {
                DyeColor var2_5 = color;
                int var3_10 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "LIGHT_GRAY", "GRAY", "BLACK", "BROWN", "RED", "YELLOW", "ORANGE", "LIME", "GREEN", "CYAN", "LIGHT_BLUE", "BLUE", "PURPLE", "MAGENTA", "PINK"}, (DyeColor)var2_5, var3_10)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Items.WHITE_DIAMOND_BACKPACK.get();
                    }
                    case 1: {
                        yield Items.LIGHT_GRAY_DIAMOND_BACKPACK.get();
                    }
                    case 2: {
                        yield Items.GRAY_DIAMOND_BACKPACK.get();
                    }
                    case 3: {
                        yield Items.BLACK_DIAMOND_BACKPACK.get();
                    }
                    case 4: {
                        yield Items.BROWN_DIAMOND_BACKPACK.get();
                    }
                    case 5: {
                        yield Items.RED_DIAMOND_BACKPACK.get();
                    }
                    case 6: {
                        yield Items.YELLOW_DIAMOND_BACKPACK.get();
                    }
                    case 7: {
                        yield Items.ORANGE_DIAMOND_BACKPACK.get();
                    }
                    case 8: {
                        yield Items.LIME_DIAMOND_BACKPACK.get();
                    }
                    case 9: {
                        yield Items.GREEN_DIAMOND_BACKPACK.get();
                    }
                    case 10: {
                        yield Items.CYAN_DIAMOND_BACKPACK.get();
                    }
                    case 11: {
                        yield Items.LIGHT_BLUE_DIAMOND_BACKPACK.get();
                    }
                    case 12: {
                        yield Items.BLUE_DIAMOND_BACKPACK.get();
                    }
                    case 13: {
                        yield Items.PURPLE_DIAMOND_BACKPACK.get();
                    }
                    case 14: {
                        yield Items.MAGENTA_DIAMOND_BACKPACK.get();
                    }
                    case 15: {
                        yield Items.PINK_DIAMOND_BACKPACK.get();
                    }
                    case -1: 
                }
                yield Items.DIAMOND_BACKPACK.get();
            }
            case 4 -> {
                DyeColor var2_6 = color;
                int var3_11 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WHITE", "LIGHT_GRAY", "GRAY", "BLACK", "BROWN", "RED", "YELLOW", "ORANGE", "LIME", "GREEN", "CYAN", "LIGHT_BLUE", "BLUE", "PURPLE", "MAGENTA", "PINK"}, (DyeColor)var2_6, var3_11)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield Items.WHITE_NETHERITE_BACKPACK.get();
                    }
                    case 1: {
                        yield Items.LIGHT_GRAY_NETHERITE_BACKPACK.get();
                    }
                    case 2: {
                        yield Items.GRAY_NETHERITE_BACKPACK.get();
                    }
                    case 3: {
                        yield Items.BLACK_NETHERITE_BACKPACK.get();
                    }
                    case 4: {
                        yield Items.BROWN_NETHERITE_BACKPACK.get();
                    }
                    case 5: {
                        yield Items.RED_NETHERITE_BACKPACK.get();
                    }
                    case 6: {
                        yield Items.YELLOW_NETHERITE_BACKPACK.get();
                    }
                    case 7: {
                        yield Items.ORANGE_NETHERITE_BACKPACK.get();
                    }
                    case 8: {
                        yield Items.LIME_NETHERITE_BACKPACK.get();
                    }
                    case 9: {
                        yield Items.GREEN_NETHERITE_BACKPACK.get();
                    }
                    case 10: {
                        yield Items.CYAN_NETHERITE_BACKPACK.get();
                    }
                    case 11: {
                        yield Items.LIGHT_BLUE_NETHERITE_BACKPACK.get();
                    }
                    case 12: {
                        yield Items.BLUE_NETHERITE_BACKPACK.get();
                    }
                    case 13: {
                        yield Items.PURPLE_NETHERITE_BACKPACK.get();
                    }
                    case 14: {
                        yield Items.MAGENTA_NETHERITE_BACKPACK.get();
                    }
                    case 15: {
                        yield Items.PINK_NETHERITE_BACKPACK.get();
                    }
                    case -1: 
                }
                yield Items.NETHERITE_BACKPACK.get();
            }
        };
    }

    public static Tier determineTier(ItemStack backpack) {
        String path = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)backpack.getItem())).getPath();
        if (path.contains("leather")) {
            return Tier.LEATHER;
        }
        if (path.contains("iron")) {
            return Tier.IRON;
        }
        if (path.contains("gold")) {
            return Tier.GOLD;
        }
        if (path.contains("diamond")) {
            return Tier.DIAMOND;
        }
        if (path.contains("netherite")) {
            return Tier.NETHERITE;
        }
        throw new IllegalStateException("Invalid backpack type");
    }

    @Nullable
    public static DyeColor determineDyeColor(ItemStack backpack) {
        String path = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)backpack.getItem())).getPath();
        if (path.contains("white")) {
            return DyeColor.WHITE;
        }
        if (path.contains("light_gray")) {
            return DyeColor.LIGHT_GRAY;
        }
        if (path.startsWith("gray")) {
            return DyeColor.GRAY;
        }
        if (path.contains("black")) {
            return DyeColor.BLACK;
        }
        if (path.contains("brown")) {
            return DyeColor.BROWN;
        }
        if (path.contains("red")) {
            return DyeColor.RED;
        }
        if (path.contains("yellow")) {
            return DyeColor.YELLOW;
        }
        if (path.contains("orange")) {
            return DyeColor.ORANGE;
        }
        if (path.contains("lime")) {
            return DyeColor.LIME;
        }
        if (path.contains("green")) {
            return DyeColor.GREEN;
        }
        if (path.contains("cyan")) {
            return DyeColor.CYAN;
        }
        if (path.contains("light_blue")) {
            return DyeColor.LIGHT_BLUE;
        }
        if (path.startsWith("blue")) {
            return DyeColor.BLUE;
        }
        if (path.contains("purple")) {
            return DyeColor.PURPLE;
        }
        if (path.contains("magenta")) {
            return DyeColor.MAGENTA;
        }
        if (path.contains("pink")) {
            return DyeColor.PINK;
        }
        return null;
    }

    public static boolean isBlacklistedItem(Item theItem) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)theItem);
        return theItem instanceof BackpackItem || registryName.getPath().contains("shulker_box");
    }

    public static enum Tier {
        LEATHER,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;

    }
}

