/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.recipe;

import com.google.common.collect.ImmutableSet;
import com.iamkaf.mochila.item.BackpackItem;
import com.iamkaf.mochila.item.backpack.BackpackUtils;
import com.iamkaf.mochila.registry.RecipeSerializers;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BackpackUpgrading
extends CustomRecipe {
    private final Set<Item> UPGRADE_MATERIALS = ImmutableSet.of((Object)Items.IRON_INGOT, (Object)Items.GOLD_INGOT, (Object)Items.DIAMOND);

    public BackpackUpgrading(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack backpack = ItemStack.EMPTY;
        int backpackCount = 0;
        HashMap<Item, Integer> materialMap = new HashMap<Item, Integer>();
        for (int k = 0; k < input.size(); ++k) {
            ItemStack itemStack = input.getItem(k);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof BackpackItem) {
                ++backpackCount;
                backpack = itemStack;
                continue;
            }
            materialMap.merge(itemStack.getItem(), 1, Integer::sum);
        }
        if (backpackCount != 1) {
            return false;
        }
        if (materialMap.keySet().size() != 1) {
            return false;
        }
        Item material = (Item)materialMap.keySet().stream().findFirst().get();
        if (!this.UPGRADE_MATERIALS.contains(material)) {
            return false;
        }
        if ((Integer)materialMap.get(material) != 8) {
            return false;
        }
        BackpackUtils.Tier currentTier = BackpackUtils.determineTier(backpack);
        BackpackUtils.Tier nextTier = BackpackUtils.getNextTier(currentTier);
        if (nextTier == null) {
            return false;
        }
        return material.equals(BackpackUpgrading.getMaterialForTier(nextTier));
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack backpack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            Item item;
            ItemStack inputStack = input.getItem(i);
            if (inputStack.isEmpty() || !((item = inputStack.getItem()) instanceof BackpackItem)) continue;
            backpack = inputStack;
        }
        BackpackUtils.Tier currentTier = BackpackUtils.determineTier(backpack);
        BackpackUtils.Tier nextTier = BackpackUtils.getNextTier(currentTier);
        DyeColor color = BackpackUtils.determineDyeColor(backpack);
        assert (nextTier != null);
        Item item = BackpackUtils.getBackpackByTierAndColor(nextTier, color);
        return backpack.transmuteCopy((ItemLike)item, 1);
    }

    public static Item getMaterialForTier(BackpackUtils.Tier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case BackpackUtils.Tier.LEATHER -> Items.LEATHER;
            case BackpackUtils.Tier.IRON -> Items.IRON_INGOT;
            case BackpackUtils.Tier.GOLD -> Items.GOLD_INGOT;
            case BackpackUtils.Tier.DIAMOND -> Items.DIAMOND;
            case BackpackUtils.Tier.NETHERITE -> Items.NETHERITE_INGOT;
        };
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RecipeSerializers.BACKPACK_UPGRADING_SERIALIZER.get();
    }
}

