/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.tags;

import com.iamkaf.mochila.Constants;
import com.iamkaf.mochila.item.backpack.BackpackUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class MochilaTags {
    private static TagKey<Item> createItemTag(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Constants.resource(name));
    }

    private static TagKey<Item> createItemTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    private static TagKey<Block> createBlockTag(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Constants.resource(name));
    }

    private static TagKey<Block> createBlockTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static class Items {
        public static final TagKey<Item> BACKPACKS = MochilaTags.createItemTag("backpacks");
        public static final TagKey<Item> LEATHER_BACKPACKS = MochilaTags.createItemTag("leather_backpacks");
        public static final TagKey<Item> IRON_BACKPACKS = MochilaTags.createItemTag("iron_backpacks");
        public static final TagKey<Item> GOLD_BACKPACKS = MochilaTags.createItemTag("gold_backpacks");
        public static final TagKey<Item> DIAMOND_BACKPACKS = MochilaTags.createItemTag("diamond_backpacks");
        public static final TagKey<Item> NETHERITE_BACKPACKS = MochilaTags.createItemTag("netherite_backpacks");

        public static TagKey<Item> tagByTier(BackpackUtils.Tier tier) {
            return switch (tier) {
                default -> throw new MatchException(null, null);
                case BackpackUtils.Tier.LEATHER -> LEATHER_BACKPACKS;
                case BackpackUtils.Tier.IRON -> IRON_BACKPACKS;
                case BackpackUtils.Tier.GOLD -> GOLD_BACKPACKS;
                case BackpackUtils.Tier.DIAMOND -> DIAMOND_BACKPACKS;
                case BackpackUtils.Tier.NETHERITE -> NETHERITE_BACKPACKS;
            };
        }
    }
}

