/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item;

import com.iamkaf.amber.api.component.SimpleIntegerDataComponent;
import com.iamkaf.amber.api.item.SmartTooltip;
import com.iamkaf.amber.api.sound.SoundHelper;
import com.iamkaf.mochila.item.backpack.BackpackContainer;
import com.iamkaf.mochila.item.backpack.BackpackMenu;
import com.iamkaf.mochila.item.backpack.QuickStash;
import com.iamkaf.mochila.registry.DataComponents;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BackpackItem
extends Item {
    public static final Holder<SoundEvent> BACKPACK_EQUIP_SOUND = SoundEvents.ARMOR_EQUIP_LEATHER;
    public final BackpackContainer.BackpackSize size;

    public BackpackItem(BackpackContainer.BackpackSize size, Item.Properties properties) {
        super(properties.component((DataComponentType)DataComponents.QUICKSTASH_MODE.get(), (Object)new SimpleIntegerDataComponent(0)));
        this.size = size;
    }

    public static void onBackpackKeybindPressed(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof BackpackItem)) continue;
            BackpackItem backpack = (BackpackItem)item;
            backpack.openForPlayer((Player)player, stack);
            return;
        }
    }

    public void openForPlayer(Player player, ItemStack stack) {
        BackpackContainer container = new BackpackContainer(stack, this.size);
        SoundHelper.sendClientSound((Player)player, (SoundEvent)((SoundEvent)BACKPACK_EQUIP_SOUND.value()));
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerx) -> new BackpackMenu(container.getMenuType(), i, inventory, (Container)container, container.rows()), stack.getDisplayName()));
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        this.openForPlayer(player, stack);
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Direction direction = context.getHorizontalDirection().getOpposite();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (player != null && player.isShiftKeyDown()) {
            Direction facing;
            BlockPos blockPosBehindSign;
            BlockState blockState;
            boolean insertedx;
            boolean inserted = QuickStash.quickStash(state, player, level, pos, hand, direction, this.size, QuickStash.getMode(player.getItemInHand(hand)));
            if (inserted) {
                return InteractionResult.SUCCESS;
            }
            if (state.getBlock() instanceof WallSignBlock && (insertedx = QuickStash.quickStash(blockState = level.getBlockState(blockPosBehindSign = pos.relative((facing = (Direction)state.getValue((Property)WallSignBlock.FACING)).getOpposite())), player, level, blockPosBehindSign, hand, facing, this.size, QuickStash.getMode(player.getItemInHand(hand))))) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        QuickStash.Mode mode = ((SimpleIntegerDataComponent)stack.getOrDefault((DataComponentType)DataComponents.QUICKSTASH_MODE.get(), (Object)SimpleIntegerDataComponent.empty())).value() == 0 ? QuickStash.Mode.DUMP : QuickStash.Mode.STORE;
        new SmartTooltip().add((Component)Component.translatable((String)"item.mochila.backpack.size", (Object[])new Object[]{String.format("%s slots", BackpackContainer.sizeToInt(this.size))})).add((Component)Component.translatable((String)"item.mochila.backpack.mode", (Object[])new Object[]{mode == QuickStash.Mode.DUMP ? "\u00a7eDump" : "\u00a7bStore"}).withStyle(ChatFormatting.BLUE)).shift((Component)Component.translatable((String)("item.mochila.backpack." + mode.toString().toLowerCase())).withStyle(ChatFormatting.DARK_AQUA)).add((Component)Component.translatable((String)"item.mochila.backpack.shift").withStyle(ChatFormatting.GRAY)).into(tooltipAdder);
    }
}

