/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.item.backpack;

import com.iamkaf.amber.api.component.SimpleIntegerDataComponent;
import com.iamkaf.amber.api.event.v1.events.common.PlayerEvents;
import com.iamkaf.amber.api.sound.SoundHelper;
import com.iamkaf.mochila.item.BackpackItem;
import com.iamkaf.mochila.item.backpack.BackpackContainer;
import com.iamkaf.mochila.registry.DataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class QuickStash {
    public static final List<Block> CONTAINER_WHITELIST = List.of(Blocks.CHEST, Blocks.TRAPPED_CHEST, Blocks.BARREL, Blocks.COPPER_CHEST);

    public static Mode getMode(ItemStack stack) {
        return ((SimpleIntegerDataComponent)stack.getOrDefault((DataComponentType)DataComponents.QUICKSTASH_MODE.get(), (Object)SimpleIntegerDataComponent.empty())).value() == 0 ? Mode.DUMP : Mode.STORE;
    }

    public static void sendParticles(Direction direction, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos particlesPosition = pos.relative(direction);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)particlesPosition.getX() + 0.5, (double)particlesPosition.getY() + 0.5, (double)particlesPosition.getZ() + 0.5, 8, 0.01, -0.02, 0.01, 0.01);
        }
    }

    public static boolean quickStash(BlockState state, Player player, Level level, BlockPos pos, InteractionHand hand, Direction direction, BackpackContainer.BackpackSize size, Mode mode) {
        if (CONTAINER_WHITELIST.stream().noneMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
            return false;
        }
        BackpackContainer backpack = new BackpackContainer(player.getItemInHand(hand), size);
        Container container = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos);
        if (container != null) {
            boolean inserted = false;
            for (int i = 0; i < backpack.getContainerSize(); ++i) {
                if (mode.equals((Object)Mode.STORE) && !QuickStash.contains(backpack.getItem(i), container)) continue;
                ItemStack toInsert = ContainerHelper.takeItem((List)backpack.getItems(), (int)i);
                int inCount = toInsert.getCount();
                boolean insertingEmpty = toInsert.isEmpty();
                ItemStack remainder = HopperBlockEntity.addItem((Container)backpack, (Container)container, (ItemStack)toInsert, null);
                backpack.setItem(i, remainder);
                if (insertingEmpty || !remainder.isEmpty() && inCount <= remainder.getCount()) continue;
                inserted = true;
            }
            if (inserted) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SoundHelper.sendClientSound((Player)player, (SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value()), (SoundSource)SoundSource.PLAYERS, (float)0.5f, (float)1.0f);
                }
                QuickStash.sendParticles(direction, level, pos);
            }
            backpack.setChanged();
            return true;
        }
        return false;
    }

    public static boolean contains(ItemStack stack, Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)container.getItem(i))) continue;
            return true;
        }
        return false;
    }

    static {
        PlayerEvents.ENTITY_INTERACT.register((player, level, hand, entity) -> {
            Item patt0$temp;
            if (!level.isClientSide() && (patt0$temp = player.getItemInHand(hand).getItem()) instanceof BackpackItem) {
                BackpackItem backpackItem = (BackpackItem)patt0$temp;
                if (player.isShiftKeyDown() && entity instanceof ItemFrame) {
                    ItemFrame frame = (ItemFrame)entity;
                    Direction direction = frame.getDirection().getOpposite();
                    BlockPos blockPosBehindFrame = frame.getPos().relative(direction);
                    BlockState blockState = level.getBlockState(blockPosBehindFrame);
                    boolean inserted = QuickStash.quickStash(blockState, player, level, blockPosBehindFrame, hand, direction.getOpposite(), backpackItem.size, QuickStash.getMode(player.getItemInHand(hand)));
                    if (inserted) {
                        return InteractionResult.CONSUME;
                    }
                }
            }
            return InteractionResult.PASS;
        });
    }

    public static enum Mode {
        DUMP,
        STORE;

    }
}

