/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.mochila.registry;

import com.iamkaf.amber.api.event.v1.events.common.client.ClientTickEvents;
import com.iamkaf.amber.api.keymapping.KeybindHelper;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.mochila.Constants;
import com.iamkaf.mochila.item.BackpackItem;
import com.iamkaf.mochila.network.ChangeBackpackModePacket;
import com.iamkaf.mochila.network.MochilaNetworking;
import com.iamkaf.mochila.network.OpenBackpackPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class Keybinds {
    public static final KeyMapping.Category MOCHILA_CATEGORY = KeyMapping.Category.register((ResourceLocation)Constants.resource("mochila"));
    public static final KeyMapping OPEN_BACKPACK = new KeyMapping("key.mochila.open_backpack", InputConstants.Type.KEYSYM, 66, MOCHILA_CATEGORY);

    public static void init() {
        KeybindHelper.register((KeyMapping)OPEN_BACKPACK);
        ClientTickEvents.END_CLIENT_TICK.register(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            while (OPEN_BACKPACK.consumeClick()) {
                LocalPlayer player = minecraft.player;
                if (player == null) {
                    return;
                }
                if (minecraft.hasShiftDown()) {
                    if (!(player.getMainHandItem().getItem() instanceof BackpackItem)) continue;
                    player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
                    MochilaNetworking.CHANNEL.sendToServer((Packet)new ChangeBackpackModePacket(0));
                    continue;
                }
                boolean hasBackpack = false;
                Inventory inventory = player.getInventory();
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack stack = inventory.getItem(i);
                    if (!(stack.getItem() instanceof BackpackItem)) continue;
                    hasBackpack = true;
                    break;
                }
                if (!hasBackpack) continue;
                player.playSound((SoundEvent)BackpackItem.BACKPACK_EQUIP_SOUND.value());
                MochilaNetworking.CHANNEL.sendToServer((Packet)new OpenBackpackPacket(0));
            }
        });
    }
}

