/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatlog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import io.github.darkkronicle.advancedchatcore.chat.ChatHistory;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.interfaces.IChatMessageProcessor;
import io.github.darkkronicle.advancedchatlog.AdvancedChatLog;
import io.github.darkkronicle.advancedchatlog.config.ChatLogConfigStorage;
import io.github.darkkronicle.advancedchatlog.gui.ChatLogScreen;
import io.github.darkkronicle.advancedchatlog.util.LogChatMessage;
import io.github.darkkronicle.advancedchatlog.util.LogChatMessageSerializer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ChatLogData
implements IChatMessageProcessor {
    private static final ChatLogData INSTANCE = new ChatLogData();
    private static boolean loading = false;
    private List<LogChatMessage> messages = new ArrayList<LogChatMessage>();

    private ChatLogData() {
    }

    public static ChatLogData getInstance() {
        return INSTANCE;
    }

    private void add(ChatMessage message) {
        LogChatMessage log = new LogChatMessage(message);
        this.messages.add(0, log);
        AdvancedChatLog.logChatMessage(message.getOriginalText());
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof ChatLogScreen) {
            ((ChatLogScreen)screen).add(log);
        }
    }

    private void add(LogChatMessage message) {
        this.messages.add(0, message);
    }

    public void onMessageUpdate(ChatMessage message, IChatMessageProcessor.UpdateType type) {
        if (loading) {
            return;
        }
        if (type != IChatMessageProcessor.UpdateType.NEW) {
            return;
        }
        int width = class_310.method_1551().method_22683().method_4486() - 20;
        this.add(message.shallowClone(width));
        while (this.messages.size() > ((ConfigInteger)ChatLogConfigStorage.General.STORED_LINES.config).getIntegerValue()) {
            this.messages.remove(this.messages.size() - 1);
        }
    }

    public void normalClear() {
        if (!((ConfigBoolean)ChatLogConfigStorage.General.ONLY_MANUAL_CLEAR.config).getBooleanValue()) {
            this.clear();
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public JsonArray toJson() {
        int lines = ((ConfigInteger)ChatLogConfigStorage.General.SAVED_LINES.config).getIntegerValue();
        LogChatMessageSerializer serializer = new LogChatMessageSerializer();
        ArrayList<LogChatMessage> messages = new ArrayList<LogChatMessage>();
        for (int i = 0; i < lines && i < ChatLogData.getInstance().getMessages().size(); ++i) {
            messages.add(0, ChatLogData.getInstance().getMessages().get(i));
        }
        JsonArray array = new JsonArray();
        for (LogChatMessage message : messages) {
            try {
                array.add((JsonElement)serializer.save(message));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    public void load(JsonArray arr) {
        int i;
        loading = true;
        this.messages.clear();
        LogChatMessageSerializer serializer = new LogChatMessageSerializer();
        for (i = arr.size() - 1; i >= 0; --i) {
            JsonElement e = arr.get(i);
            if (!e.isJsonObject()) continue;
            try {
                this.messages.add(serializer.load(e.getAsJsonObject()));
                continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        for (i = Math.min(((ConfigInteger)ChatLogConfigStorage.General.RELOAD_LINES.config).getIntegerValue() - 1, this.messages.size() - 1); i >= 0; --i) {
            ChatHistory.getInstance().add(this.messages.get(i).getMessage());
        }
        loading = false;
    }

    public LogChatMessage getLogMessage(ChatMessage message) {
        for (LogChatMessage log : this.messages) {
            if (!log.getMessage().getUuid().equals(message.getUuid())) continue;
            return log;
        }
        return null;
    }

    @Generated
    public static boolean isLoading() {
        return loading;
    }

    @Generated
    public List<LogChatMessage> getMessages() {
        return this.messages;
    }
}

