/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatlog.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.SaveableConfig;
import io.github.darkkronicle.advancedchatlog.ChatLogData;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChatLogConfigStorage
implements IConfigHandler {
    public static final String CONFIG_FILE_NAME = "advancedchatlog.json";
    private static final int CONFIG_VERSION = 1;

    public static void loadFromFile() {
        JsonElement element;
        File configFile = FileUtils.getConfigDirectoryAsPath().resolve("advancedchat").resolve(CONFIG_FILE_NAME).toFile();
        File savedFile = FileUtils.getConfigDirectoryAsPath().resolve("advancedchat").resolve("saved_lines.json").toFile();
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = ConfigStorage.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigStorage.readOptions((JsonObject)root, (String)"general", General.OPTIONS);
            ConfigStorage.readOptions((JsonObject)root, (String)"hotkeys", Hotkeys.OPTIONS);
            int n = JsonUtils.getIntegerOrDefault((JsonObject)root, (String)"configVersion", (int)0);
        }
        if (savedFile.exists() && savedFile.isFile() && savedFile.canRead() && (element = ConfigStorage.parseJsonFile((File)savedFile)) != null && element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.has("lines")) {
                return;
            }
            JsonElement el = obj.get("lines");
            if (!el.isJsonArray()) {
                return;
            }
            ChatLogData.getInstance().load(el.getAsJsonArray());
        }
    }

    public static void saveFromFile() {
        File dir = FileUtils.getConfigDirectoryAsPath().resolve("advancedchat").toFile();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigStorage.writeOptions((JsonObject)root, (String)"general", General.OPTIONS);
            ConfigStorage.writeOptions((JsonObject)root, (String)"hotkeys", Hotkeys.OPTIONS);
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            ConfigStorage.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
            Object writer = null;
            File file = new File(dir, "saved_lines.json");
            JsonObject saved = new JsonObject();
            saved.add("lines", (JsonElement)ChatLogData.getInstance().toJson());
            ConfigStorage.writeJsonToFile((JsonObject)saved, (File)file);
        }
    }

    public void load() {
        ChatLogConfigStorage.loadFromFile();
    }

    public void save() {
        ChatLogConfigStorage.saveFromFile();
    }

    public static class General {
        public static final String NAME = "general";
        public static final SaveableConfig<ConfigInteger> STORED_LINES = SaveableConfig.fromConfig((String)"stored_lines", (IConfigBase)new ConfigInteger(General.translate("stored_lines"), 1000, 50, 10000, General.translate("info.stored_lines")));
        public static final SaveableConfig<ConfigBoolean> ONLY_MANUAL_CLEAR = SaveableConfig.fromConfig((String)"only_manual_clear", (IConfigBase)new ConfigBoolean(General.translate("only_manual_clear"), true, General.translate("info.only_manual_clear")));
        public static final SaveableConfig<ConfigInteger> SCROLL_TIME = SaveableConfig.fromConfig((String)"scroll_time", (IConfigBase)new ConfigInteger(General.translate("scroll_time"), 200, 0, 2000, General.translate("info.scroll_time")));
        public static final SaveableConfig<ConfigOptionList> SCROLL_TYPE = SaveableConfig.fromConfig((String)"scroll_type", (IConfigBase)new ConfigOptionList(General.translate("scroll_type"), (IConfigOptionListEntry)ConfigStorage.Easing.QUART, General.translate("info.scroll_time")));
        public static final SaveableConfig<ConfigDouble> SCROLL_MULTIPLIER = SaveableConfig.fromConfig((String)"scroll_multiplier", (IConfigBase)new ConfigDouble(General.translate("scroll_multiplier"), 5.0, 0.0, 100.0, General.translate("info.scroll_multiplier")));
        public static final SaveableConfig<ConfigInteger> SAVED_LINES = SaveableConfig.fromConfig((String)"saved_lines", (IConfigBase)new ConfigInteger(General.translate("saved_lines"), 0, 0, 10000, General.translate("info.saved_lines")));
        public static final SaveableConfig<ConfigInteger> RELOAD_LINES = SaveableConfig.fromConfig((String)"reload_lines", (IConfigBase)new ConfigInteger(General.translate("reload_lines"), 0, 0, 10000, General.translate("info.reload_lines")));
        public static final SaveableConfig<ConfigBoolean> CLEAN_SAVE = SaveableConfig.fromConfig((String)"clean_save", (IConfigBase)new ConfigBoolean(General.translate("clean_save"), false, General.translate("info.clean_save")));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(STORED_LINES, ONLY_MANUAL_CLEAR, SAVED_LINES, RELOAD_LINES, CLEAN_SAVE, SCROLL_TIME, SCROLL_TYPE, SCROLL_MULTIPLIER);

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchatlog.config.general." + key), (Object[])new Object[0]);
        }
    }

    public static class Hotkeys {
        public static final String NAME = "hotkeys";
        public static final SaveableConfig<ConfigHotkey> OPEN_LOG = SaveableConfig.fromConfig((String)"openSettings", (IConfigBase)new ConfigHotkey(Hotkeys.translate("openlog"), "U", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.INGAME, (KeyAction)KeyAction.PRESS, (boolean)false, (boolean)true, (boolean)false, (boolean)true), Hotkeys.translate("info.openlog")));
        public static final ImmutableList<ConfigHotkey> HOTKEYS = ImmutableList.of((Object)((ConfigHotkey)Hotkeys.OPEN_LOG.config));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(OPEN_LOG);

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchatlog.config.hotkeys." + key), (Object[])new Object[0]);
        }
    }
}

