/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatlog.gui;

import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.gui.ContextMenu;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchatcore.util.SearchUtils;
import io.github.darkkronicle.advancedchatlog.AdvancedChatLog;
import io.github.darkkronicle.advancedchatlog.ChatLogData;
import io.github.darkkronicle.advancedchatlog.config.ChatLogConfigStorage;
import io.github.darkkronicle.advancedchatlog.gui.ScissorUtil;
import io.github.darkkronicle.advancedchatlog.gui.TextFieldRunnable;
import io.github.darkkronicle.advancedchatlog.util.LogChatMessage;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class ChatLogScreen
extends GuiBase {
    private double scrollStart = 0.0;
    private double scrollEnd = 0.0;
    private double currentScroll = 0.0;
    private long lastScrollTime = 0L;
    private ContextMenu menu = null;
    private LogChatMessage message = null;
    private List<ChatMessage.AdvancedChatLine> renderLines;
    private GuiTextFieldGeneric search = null;
    private TextFieldRunnable send = null;
    private ButtonGeneric searchType = null;
    private FindType findType = FindType.LITERAL;

    public void add(LogChatMessage message) {
        this.add(message.getMessage());
        if (this.currentScroll > 0.0) {
            int n = message.getMessage().getLineCount();
            Objects.requireNonNull(this.field_22787.field_1772);
            this.currentScroll += (double)(n * (9 + 2));
        }
    }

    public void add(ChatMessage message) {
        try {
            if (SearchUtils.isMatch((String)message.getDisplayText().getString(), (String)this.search.method_1882(), (FindType)this.findType)) {
                for (int i = 0; i < message.getLineCount(); ++i) {
                    this.renderLines.add(0, (ChatMessage.AdvancedChatLine)message.getLines().get(i));
                }
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public void initGui() {
        super.initGui();
        this.setLines(ChatLogData.getInstance().getMessages());
        int width = this.field_22787.method_22683().method_4486();
        int height = this.field_22787.method_22683().method_4502();
        this.search = new GuiTextFieldGeneric(width / 2 - 70, 6, 141, 20, this.textRenderer);
        this.addTextField(this.search, textField -> {
            this.searchText(textField.method_1882());
            return true;
        });
        this.searchType = new ButtonGeneric(width / 2 + 72, 6, 70, false, this.findType.getDisplayName(), new Object[0]);
        this.addButton((ButtonBase)this.searchType, (button, mouseButton) -> {
            this.findType = mouseButton == 0 ? this.findType.cycle(true) : this.findType.cycle(false);
            button.setDisplayString(this.findType.getDisplayName());
            this.searchText(this.search.method_1882());
        });
        this.send = new TextFieldRunnable(2, height - 15, width - 4, 12, this.textRenderer, textFieldRunnable -> {
            String text = textFieldRunnable.method_1882();
            class_5250 literal = class_2561.method_43470((String)text);
            this.field_22787.field_1724.method_7353((class_2561)literal, false);
            textFieldRunnable.method_1852("");
        });
        this.addTextField(this.send, null);
        this.send.method_25365(true);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 1) {
            this.createContextMenu(mouseX, mouseY);
            return true;
        }
        if (this.menu != null && this.menu.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (ChatLogScreen.method_25442()) {
            this.relativeScroll(mouseY);
            return true;
        }
        class_2583 style = this.getHoverStyle(mouseX, mouseY);
        if (style != null) {
            return this.method_25430(style);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (ChatLogScreen.method_25442()) {
            this.relativeScroll((int)mouseY);
            return true;
        }
        return false;
    }

    public void relativeScroll(int y) {
        int height = this.field_22787.method_22683().method_4502() - 100;
        float percent = 1.0f - Math.max(0.0f, Math.min((float)(y -= 40) / (float)height, 1.0f));
        int n = this.renderLines.size();
        Objects.requireNonNull(this.textRenderer);
        int newPix = (int)(percent * (float)(n * (9 + 2)));
        this.scrollEnd = newPix;
        this.scrollStart = newPix;
        this.lastScrollTime = class_156.method_658();
    }

    private void searchText(String contents) {
        if (contents.isEmpty()) {
            this.setLines(ChatLogData.getInstance().getMessages());
            return;
        }
        ArrayList<LogChatMessage> sorted = new ArrayList<LogChatMessage>();
        for (LogChatMessage l : ChatLogData.getInstance().getMessages()) {
            ChatMessage m = l.getMessage();
            try {
                if (!SearchUtils.isMatch((String)m.getDisplayText().getString(), (String)contents, (FindType)this.findType)) continue;
                sorted.add(l);
            }
            catch (PatternSyntaxException e) {
                sorted.clear();
                class_5250 text = class_2561.method_43470((String)StringUtils.translate((String)"advancedchatlog.message.regexerror", (Object[])new Object[0])).method_27696(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)));
                text.method_10855().add(class_2561.method_43470((String)(" " + e.getDescription())).method_27696(class_2583.field_24360.method_36139(Colors.getInstance().getColorOrWhite("gray").color())));
                ChatMessage message = ChatMessage.builder().displayText((class_2561)text).originalText((class_2561)text).build();
                sorted.add(new LogChatMessage(message));
                break;
            }
        }
        this.setLines(sorted);
    }

    private void setLines(List<LogChatMessage> messages) {
        if ((messages = new ArrayList<LogChatMessage>(messages)).isEmpty()) {
            class_5250 text = class_2561.method_43470((String)StringUtils.translate((String)"advancedchatlog.message.none", (Object[])new Object[0])).method_27696(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)));
            messages.add(new LogChatMessage(ChatMessage.builder().displayText((class_2561)text).originalText((class_2561)text).build()));
        }
        this.renderLines = new ArrayList<ChatMessage.AdvancedChatLine>();
        for (LogChatMessage l : messages) {
            ChatMessage m = l.getMessage();
            for (int i = m.getLineCount() - 1; i >= 0; --i) {
                this.renderLines.add((ChatMessage.AdvancedChatLine)m.getLines().get(i));
            }
        }
    }

    private void updateScroll() {
        int maxY;
        long time = class_156.method_658();
        this.currentScroll = this.scrollStart + (this.scrollEnd - this.scrollStart) * (1.0 - ((ConfigStorage.Easing)((ConfigOptionList)ChatLogConfigStorage.General.SCROLL_TYPE.config).getOptionListValue()).apply((double)(1.0f - ((float)time - (float)this.lastScrollTime) / (float)((ConfigInteger)ChatLogConfigStorage.General.SCROLL_TIME.config).getIntegerValue())));
        Objects.requireNonNull(this.textRenderer);
        int fontHeight = 9 + 2;
        if (this.currentScroll < 0.0) {
            this.currentScroll = 0.0;
            this.scrollEnd = 0.0;
            this.lastScrollTime = 0L;
        }
        if (this.currentScroll >= (double)(maxY = fontHeight * (this.renderLines.size() - 1))) {
            this.currentScroll = maxY;
            this.scrollEnd = maxY;
            this.lastScrollTime = 0L;
        }
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double horizontalAmount, double verticalAmount) {
        if (super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        this.scrollEnd = this.currentScroll + verticalAmount * 10.0 * ((ConfigDouble)ChatLogConfigStorage.General.SCROLL_MULTIPLIER.config).getDoubleValue();
        this.scrollStart = this.currentScroll;
        this.lastScrollTime = class_156.method_658();
        return true;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
        this.updateScroll();
        int height = this.field_22787.method_22683().method_4502();
        int width = this.field_22787.method_22683().method_4486();
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int lines = (int)Math.ceil((float)(height - 70 - lineHeight) / (float)lineHeight);
        int scrollLine = (int)Math.floor((float)this.currentScroll / (float)lineHeight);
        int y = -1 * ((int)this.currentScroll % lineHeight);
        double scale = this.field_22787.method_22683().method_4495();
        ScissorUtil.applyScissor(drawContext, 0, (int)(40.0 * scale), (int)((double)width * scale), (int)((double)(height - 70) * scale));
        for (int i = scrollLine; i < scrollLine + lines && i < this.renderLines.size(); ++i) {
            ChatMessage.AdvancedChatLine line = this.renderLines.get(i);
            drawContext.method_27535(this.textRenderer, line.getText(), 10, height - y - 40 - this.fontHeight, Colors.getInstance().getColorOrWhite("white").color());
            y += lineHeight;
        }
        drawContext.method_44380();
        drawContext.method_25300(this.textRenderer, scrollLine + 1 + "/" + this.renderLines.size(), width / 2, height - 28, Colors.getInstance().getColorOrWhite("white").color());
        drawContext.method_51441(this.textRenderer, this.getHoverStyle(mouseX, mouseY), mouseX, mouseY);
        if (this.menu != null) {
            this.menu.render(drawContext, mouseX, mouseY, true);
        }
    }

    public void createContextMenu(int mouseX, int mouseY) {
        LinkedHashMap<class_5250, ContextMenu.ContextConsumer> actions = new LinkedHashMap<class_5250, ContextMenu.ContextConsumer>();
        this.message = this.getMessage(mouseX, mouseY);
        if (this.message != null) {
            class_5250 data = class_2561.method_43473();
            try {
                data.method_10855().add(class_2561.method_43470((String)this.message.getMessage().getTime().format(DateTimeFormatter.ofPattern(((ConfigString)ConfigStorage.General.TIME_FORMAT.config).getStringValue()))).method_27696(class_2583.field_24360.method_27706(class_124.field_1075)));
            }
            catch (IllegalArgumentException e) {
                AdvancedChatLog.LOGGER.log(Level.WARN, "Can't format time for context menu!", (Throwable)e);
            }
            if (this.message.getMessage().getOwner() != null) {
                data.method_10855().add(class_2561.method_43470((String)" - ").method_27696(class_2583.field_24360.method_27706(class_124.field_1080)));
                if (this.message.getMessage().getOwner().getEntry().method_2971() != null) {
                    data.method_10855().add(this.message.getMessage().getOwner().getEntry().method_2971());
                } else {
                    data.method_10855().add(class_2561.method_43470((String)this.message.getMessage().getOwner().getEntry().method_2966().getName()));
                }
            }
            if (!data.getString().isBlank()) {
                actions.put(data, (x, y) -> {});
            }
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchatlog.context.copy", (Object[])new Object[0])), (x, y) -> {
                class_310.method_1551().field_1774.method_1455(this.message.getMessage().getOriginalText().getString());
                InfoUtils.printActionbarMessage((String)"advancedchatlog.context.copied", (Object[])new Object[0]);
            });
        }
        actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchatlog.context.clearallmessages", (Object[])new Object[0])), (x, y) -> {
            ChatLogData.getInstance().clear();
            this.setLines(ChatLogData.getInstance().getMessages());
        });
        this.menu = new ContextMenu(mouseX, mouseY, actions, () -> {
            this.menu = null;
        });
    }

    public class_2583 getHoverStyle(double mouseX, double mouseY) {
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int lines = (int)Math.ceil((float)(this.field_22790 - 70 - lineHeight) / (float)lineHeight);
        int scrollLine = (int)Math.floor((float)this.currentScroll / (float)lineHeight);
        int y = -1 * ((int)this.currentScroll % lineHeight);
        int height = this.field_22787.method_22683().method_4502();
        mouseY = (double)height - mouseY - 40.0;
        mouseX -= 10.0;
        for (int i = scrollLine; i < scrollLine + lines && i < this.renderLines.size(); ++i) {
            if ((double)y <= mouseY && (double)(y + lineHeight) >= mouseY) {
                ChatMessage.AdvancedChatLine line = this.renderLines.get(i);
                return this.textRenderer.method_27527().method_27489((class_5348)line.getText(), (int)mouseX);
            }
            y += lineHeight;
        }
        return null;
    }

    public LogChatMessage getMessage(double mouseX, double mouseY) {
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int lines = (int)Math.ceil((float)(this.field_22790 - 70 - lineHeight) / (float)lineHeight);
        int scrollLine = (int)Math.floor((float)this.currentScroll / (float)lineHeight);
        int y = -1 * ((int)this.currentScroll % lineHeight);
        int height = this.field_22787.method_22683().method_4502();
        mouseY = (double)height - mouseY - 40.0;
        for (int i = scrollLine; i < scrollLine + lines && i < this.renderLines.size(); ++i) {
            if ((double)y <= mouseY && (double)(y + lineHeight) >= mouseY) {
                ChatMessage.AdvancedChatLine line = this.renderLines.get(i);
                return ChatLogData.getInstance().getLogMessage(line.getParent());
            }
            y += lineHeight;
        }
        return null;
    }
}

