/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatlog.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.interfaces.IJsonSave;
import io.github.darkkronicle.advancedchatlog.config.ChatLogConfigStorage;
import io.github.darkkronicle.advancedchatlog.util.LogChatMessage;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class LogChatMessageSerializer
implements IJsonSave<LogChatMessage> {
    private static final Gson GSON = new Gson();
    private DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    private class_2583 cleanStyle(class_2583 style) {
        if (!((ConfigBoolean)ChatLogConfigStorage.General.CLEAN_SAVE.config).getBooleanValue()) {
            return style;
        }
        style = style.method_10958(null);
        style = style.method_10949(null);
        style = style.method_10975(null);
        return style;
    }

    private class_2561 transfer(class_2561 text) {
        class_5250 base = class_2561.method_43473();
        for (class_2561 t : text.method_10855()) {
            class_5250 newT = class_2561.method_43470((String)t.getString()).method_27696(this.cleanStyle(t.method_10866()));
            base.method_10855().add(newT);
        }
        return base;
    }

    public LogChatMessage load(JsonObject obj) {
        LocalDateTime dateTime = LocalDateTime.from(this.formatter.parse(obj.get("time").getAsString()));
        LocalDate date = dateTime.toLocalDate();
        LocalTime time = dateTime.toLocalTime();
        class_2561 display = (class_2561)GSON.fromJson(obj.get("display"), class_2561.class);
        class_2561 original = (class_2561)GSON.fromJson(obj.get("original"), class_2561.class);
        byte stacks = obj.get("stacks").getAsByte();
        ChatMessage message = ChatMessage.builder().time(time).displayText(display).originalText(original).build();
        LogChatMessage log = new LogChatMessage(message, date);
        return log;
    }

    public JsonObject save(LogChatMessage message) {
        JsonObject json = new JsonObject();
        ChatMessage chat = message.getMessage();
        LocalDateTime dateTime = LocalDateTime.of(message.getDate(), chat.getTime());
        json.addProperty("time", this.formatter.format(dateTime));
        json.addProperty("stacks", (Number)chat.getStacks());
        json.add("display", GSON.toJsonTree((Object)this.transfer(chat.getDisplayText())));
        json.add("original", GSON.toJsonTree((Object)this.transfer(chat.getOriginalText())));
        return json;
    }
}

