/*
 * Decompiled with CFR 0.152.
 */
package me.drex.orderedplayerlist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.Strictness;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.drex.orderedplayerlist.OrderedPlayerList;
import me.drex.orderedplayerlist.config.Config;
import me.drex.orderedplayerlist.config.sequence.Sequence;
import me.drex.orderedplayerlist.config.sequence.util.ComparisonMode;
import me.drex.orderedplayerlist.config.sequence.util.PlayerComparator;
import me.drex.orderedplayerlist.util.serializer.ComparisonModeSerializer;
import me.drex.orderedplayerlist.util.serializer.PlayerComparatorSerializer;
import me.drex.orderedplayerlist.util.serializer.SequenceSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setStrictness(Strictness.LENIENT).registerTypeAdapter(PlayerComparator.class, (Object)new PlayerComparatorSerializer()).registerTypeAdapter(ComparisonMode.class, (Object)new ComparisonModeSerializer()).registerTypeAdapter(Sequence.class, (Object)SequenceSerializer.INSTANCE).registerTypeHierarchyAdapter(class_2960.class, new RegistryUnawareCodecSerializer(class_2960.field_25139)).create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("ordered-playerlist.json");

    private ConfigManager() {
    }

    public static boolean load() {
        if (CONFIG_FILE.toFile().exists()) {
            try {
                Config.INSTANCE = (Config)GSON.fromJson(Files.readString(CONFIG_FILE), Config.class);
                return true;
            }
            catch (Exception ex) {
                OrderedPlayerList.LOGGER.error("Failed to load config file!", (Throwable)ex);
                return false;
            }
        }
        try {
            Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((Object)Config.INSTANCE), new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            OrderedPlayerList.LOGGER.error("Failed to save config file!", (Throwable)ex);
            return false;
        }
    }

    private record RegistryUnawareCodecSerializer<T>(Codec<T> codec) implements JsonSerializer<T>,
    JsonDeserializer<T>
    {
        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return (T)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
            }
            catch (Throwable e) {
                return null;
            }
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            try {
                return src != null ? (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, src).getOrThrow() : JsonNull.INSTANCE;
            }
            catch (Throwable e) {
                return JsonNull.INSTANCE;
            }
        }
    }
}

