/*
 * Decompiled with CFR 0.152.
 */
package me.drex.orderedplayerlist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.drex.orderedplayerlist.OrderedPlayerList;
import me.drex.orderedplayerlist.config.Config;
import me.drex.orderedplayerlist.config.sequence.Sequence;
import me.drex.orderedplayerlist.config.sequence.util.ComparisonMode;
import me.drex.orderedplayerlist.config.sequence.util.PlayerComparator;
import me.drex.orderedplayerlist.util.serializer.ComparisonModeSerializer;
import me.drex.orderedplayerlist.util.serializer.PlayerComparatorSerializer;
import me.drex.orderedplayerlist.util.serializer.SequenceSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().registerTypeAdapter(PlayerComparator.class, (Object)new PlayerComparatorSerializer()).registerTypeAdapter(ComparisonMode.class, (Object)new ComparisonModeSerializer()).registerTypeAdapter(Sequence.class, (Object)SequenceSerializer.INSTANCE).registerTypeHierarchyAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("ordered-playerlist.json");

    private ConfigManager() {
    }

    public static boolean load() {
        if (CONFIG_FILE.toFile().exists()) {
            try {
                Config.INSTANCE = (Config)GSON.fromJson(Files.readString(CONFIG_FILE), Config.class);
                return true;
            }
            catch (Exception ex) {
                OrderedPlayerList.LOGGER.error("Failed to load config file!", (Throwable)ex);
                return false;
            }
        }
        try {
            Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((Object)Config.INSTANCE), new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            OrderedPlayerList.LOGGER.error("Failed to save config file!", (Throwable)ex);
            return false;
        }
    }
}

