/*
 * Decompiled with CFR 0.152.
 */
package me.drex.orderedplayerlist.util.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.drex.orderedplayerlist.config.sequence.util.ComparisonMode;

public class ComparisonModeSerializer
implements JsonSerializer<ComparisonMode<?>>,
JsonDeserializer<ComparisonMode<?>> {
    public ComparisonMode<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String id = json.getAsString();
        ComparisonMode<?> mode = ComparisonMode.COMPARISON_MODES.get(id);
        if (mode != null) {
            return mode;
        }
        throw new JsonParseException("Invalid comparison mode \"" + id + "\"!");
    }

    public JsonElement serialize(ComparisonMode<?> src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.id());
    }
}

