/*
 * Decompiled with CFR 0.152.
 */
package me.drex.orderedplayerlist.util.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.drex.orderedplayerlist.config.sequence.MetadataSequence;
import me.drex.orderedplayerlist.config.sequence.PlaceholderSequence;
import me.drex.orderedplayerlist.config.sequence.Sequence;
import net.minecraft.class_2960;

public final class SequenceSerializer
implements JsonSerializer<Sequence>,
JsonDeserializer<Sequence> {
    public static final SequenceSerializer INSTANCE = new SequenceSerializer();
    public static final Map<class_2960, Class<? extends Sequence>> ID_TO_CLASS = new HashMap<class_2960, Class<? extends Sequence>>();
    public static final Map<Class<? extends Sequence>, class_2960> CLASS_TO_ID = new HashMap<Class<? extends Sequence>, class_2960>();

    private SequenceSerializer() {
    }

    public Sequence deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonElement json = jsonElement.getAsJsonObject().get("type");
            if (json != null) {
                class_2960 resourceLocation = (class_2960)context.deserialize(json, class_2960.class);
                Class<? extends Sequence> clazz = ID_TO_CLASS.get(resourceLocation);
                if (clazz != null) {
                    return (Sequence)context.deserialize(jsonElement, clazz);
                }
                throw new IllegalArgumentException("Invalid sequence type \"" + json.getAsString() + "\"!");
            }
            throw new IllegalArgumentException("Missing sequence type!");
        }
        catch (Throwable t) {
            throw new JsonParseException(t);
        }
    }

    public JsonElement serialize(Sequence src, Type type, JsonSerializationContext context) {
        class_2960 resourceLocation = CLASS_TO_ID.get(src.getClass());
        if (resourceLocation != null) {
            JsonObject jsonObject = context.serialize((Object)src).getAsJsonObject();
            jsonObject.addProperty("type", resourceLocation.method_12836().equals("minecraft") ? resourceLocation.method_12832() : resourceLocation.toString());
            return jsonObject;
        }
        throw new JsonParseException("Unknown sequence \"" + String.valueOf(src) + "\", missing register()!");
    }

    public static <T extends Sequence> void register(class_2960 resourceLocation, Class<T> type) {
        ID_TO_CLASS.put(resourceLocation, type);
        CLASS_TO_ID.put(type, resourceLocation);
    }

    static {
        SequenceSerializer.register(PlaceholderSequence.ID, PlaceholderSequence.class);
        SequenceSerializer.register(MetadataSequence.ID, MetadataSequence.class);
    }
}

