/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sun.management.OperatingSystemMXBean;
import de.meisterah.serverStatusAPI.MetricStore;
import de.meisterah.serverStatusAPI.SQLiteStore;
import de.meisterah.serverStatusAPI.ServerStatusAPI;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MetricsCollector
implements Listener {
    private final MetricStore store;
    private final int intervalSeconds;
    private final int historySaveInterval;
    private final ServerStatusAPI plugin;
    private boolean storeMetrics;
    private BukkitTask collectionTask;
    private BukkitTask cleanupTask;
    private int collectionCount = 0;

    public MetricsCollector(MetricStore store, int intervalSeconds, ServerStatusAPI plugin) {
        this.store = store;
        this.intervalSeconds = intervalSeconds;
        this.plugin = plugin;
        this.storeMetrics = plugin.getConfig().getBoolean("store-metrics", true);
        this.historySaveInterval = plugin.getConfig().getInt("history-save-interval", 60);
        plugin.getLogger().info("Metrics collection interval: " + intervalSeconds + "s");
        if (this.storeMetrics) {
            plugin.getLogger().info("History save interval: " + this.historySaveInterval + "s");
        }
        this.startCollection();
        this.startCleanupTask();
    }

    public void setStoreMetrics(boolean storeMetrics) {
        this.storeMetrics = storeMetrics;
        this.plugin.getLogger().info("Metrics storage " + (storeMetrics ? "enabled" : "disabled"));
    }

    private void startCollection() {
        this.collectionTask = new BukkitRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean shouldSaveHistory;
                    double tps = Bukkit.getServer().getTPS()[0];
                    long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    long maxMemory = Runtime.getRuntime().maxMemory();
                    int onlinePlayers = Bukkit.getOnlinePlayers().size();
                    int maxPlayers = Bukkit.getMaxPlayers();
                    double cpuUsage = 0.0;
                    java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
                    if (osBean instanceof OperatingSystemMXBean) {
                        cpuUsage = ((OperatingSystemMXBean)osBean).getProcessCpuLoad() * 100.0;
                        cpuUsage = (double)Math.round(cpuUsage * 100.0) / 100.0;
                    }
                    int loadedChunks = 0;
                    int entityCount = 0;
                    for (World world : Bukkit.getWorlds()) {
                        if (world == null) continue;
                        loadedChunks += world.getLoadedChunks().length;
                        entityCount += world.getEntities().size();
                    }
                    HashMap<String, Integer> entityCountPerWorld = new HashMap<String, Integer>();
                    HashMap<String, Map<String, Integer>> entityDistributionPerWorld = new HashMap<String, Map<String, Integer>>();
                    for (World world : Bukkit.getWorlds()) {
                        if (world == null) continue;
                        String worldKey = world.getEnvironment().name().toLowerCase();
                        int count = 0;
                        HashMap<String, Integer> distribution = new HashMap<String, Integer>();
                        for (Entity e : world.getEntities()) {
                            if (e == null) continue;
                            String type = e.getType().name();
                            distribution.put(type, distribution.getOrDefault(type, 0) + 1);
                            ++count;
                        }
                        entityCountPerWorld.put(worldKey, count);
                        entityDistributionPerWorld.put(worldKey, distribution);
                    }
                    int pingSum = 0;
                    ArrayList<ServerStatusAPI.PlayerInfo> playerInfos = new ArrayList<ServerStatusAPI.PlayerInfo>();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (p == null) continue;
                        int ping = 0;
                        try {
                            ping = p.getPing();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        pingSum += ping;
                        long sessionStart = 0L;
                        long totalPlaytime = 0L;
                        Map<UUID, Long> map = MetricsCollector.this.plugin.playerSessionStart;
                        synchronized (map) {
                            Long start = MetricsCollector.this.plugin.playerSessionStart.get(p.getUniqueId());
                            if (start != null) {
                                sessionStart = start;
                            }
                        }
                        map = MetricsCollector.this.plugin.playerTotalPlaytime;
                        synchronized (map) {
                            totalPlaytime = MetricsCollector.this.plugin.playerTotalPlaytime.getOrDefault(p.getUniqueId(), 0L);
                        }
                        if (sessionStart > 0L) {
                            totalPlaytime += System.currentTimeMillis() - sessionStart;
                        }
                        playerInfos.add(new ServerStatusAPI.PlayerInfo(p.getUniqueId(), p.getName(), ping, sessionStart, totalPlaytime));
                    }
                    int avgPing = onlinePlayers > 0 ? pingSum / onlinePlayers : 0;
                    MetricsCollector.this.plugin.updateLiveStats(tps, usedMemory, maxMemory, onlinePlayers, maxPlayers, cpuUsage, loadedChunks, entityCount, avgPing, playerInfos, entityCountPerWorld, entityDistributionPerWorld);
                    ++MetricsCollector.this.collectionCount;
                    boolean bl = shouldSaveHistory = MetricsCollector.this.collectionCount * MetricsCollector.this.intervalSeconds >= MetricsCollector.this.historySaveInterval;
                    if (MetricsCollector.this.storeMetrics && shouldSaveHistory) {
                        MetricsCollector.this.collectionCount = 0;
                        JsonArray playersArr = new JsonArray();
                        for (ServerStatusAPI.PlayerInfo info : playerInfos) {
                            JsonObject p = new JsonObject();
                            p.addProperty("uuid", info.uuid.toString());
                            p.addProperty("ping", info.ping);
                            long sessionOnlineMillis = info.sessionStart > 0L ? System.currentTimeMillis() - info.sessionStart : 0L;
                            long totalPlaytimeMillis = info.totalPlaytime;
                            if (sessionOnlineMillis > totalPlaytimeMillis) {
                                sessionOnlineMillis = totalPlaytimeMillis;
                            }
                            p.addProperty("sessionOnlineMillis", sessionOnlineMillis);
                            p.addProperty("totalPlaytimeMillis", totalPlaytimeMillis);
                            playersArr.add(p);
                        }
                        String serverAddress = Bukkit.getServer().getIp() + ":" + Bukkit.getServer().getPort();
                        ((SQLiteStore)MetricsCollector.this.store).saveFullMetrics(tps, usedMemory, maxMemory, onlinePlayers, maxPlayers, cpuUsage, loadedChunks, entityCount, MetricsCollector.this.plugin.getUptimeMillis(), avgPing, playersArr.toString(), serverAddress);
                    }
                    if (MetricsCollector.this.plugin.getConfig().getBoolean("debug-mode", false)) {
                        String savedMsg = shouldSaveHistory && MetricsCollector.this.storeMetrics ? " [SAVED TO DB]" : "";
                        MetricsCollector.this.plugin.getLogger().info(String.format("[DEBUG] Metrics collected - TPS: %.2f, Memory: %dMB/%dMB, Players: %d/%d, CPU: %.2f%%, Chunks: %d, Entities: %d, Ping: %dms%s", tps, usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L, onlinePlayers, maxPlayers, cpuUsage, loadedChunks, entityCount, avgPing, savedMsg));
                    }
                }
                catch (Exception e) {
                    MetricsCollector.this.plugin.getLogger().severe("Error during metrics collection: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.intervalSeconds * 20L);
    }

    private void startCleanupTask() {
        this.cleanupTask = new BukkitRunnable(){

            public void run() {
                try {
                    if (MetricsCollector.this.storeMetrics) {
                        int retentionDays = MetricsCollector.this.plugin.getConfig().getInt("history-retention-days", 30);
                        ((SQLiteStore)MetricsCollector.this.store).deleteOldMetrics(retentionDays);
                        MetricsCollector.this.plugin.getLogger().info("Old metrics cleaned up (older than " + retentionDays + " days)");
                    }
                }
                catch (Exception e) {
                    MetricsCollector.this.plugin.getLogger().warning("Error during metrics cleanup: " + e.getMessage());
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 72000L, 72000L);
    }

    public void stopCollection() {
        if (this.collectionTask != null && !this.collectionTask.isCancelled()) {
            this.collectionTask.cancel();
            this.plugin.getLogger().info("Metrics collection task stopped.");
        }
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel();
        }
    }
}

