/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import com.google.common.util.concurrent.RateLimiter;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RateLimitingHandler
implements HttpHandler {
    private final HttpHandler delegate;
    private final Map<String, RateLimiter> limiters = new ConcurrentHashMap<String, RateLimiter>();
    private final double requestsPerSecond;
    private final boolean enabled;

    public RateLimitingHandler(HttpHandler delegate, int requestsPerMinute) {
        this.delegate = delegate;
        this.enabled = requestsPerMinute > 0;
        this.requestsPerSecond = (double)requestsPerMinute / 60.0;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        if (!this.enabled) {
            this.delegate.handle(exchange);
            return;
        }
        String clientIP = exchange.getRemoteAddress().getAddress().getHostAddress();
        RateLimiter limiter = this.limiters.computeIfAbsent(clientIP, k -> RateLimiter.create(this.requestsPerSecond));
        if (!limiter.tryAcquire()) {
            String response = "{\"error\":\"Rate limit exceeded. Please slow down.\"}";
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.getResponseHeaders().add("Retry-After", "60");
            exchange.sendResponseHeaders(429, response.getBytes().length);
            exchange.getResponseBody().write(response.getBytes());
            exchange.getResponseBody().close();
            return;
        }
        this.delegate.handle(exchange);
    }

    public void cleanup() {
        if (this.limiters.size() > 1000) {
            int toRemove = this.limiters.size() / 2;
            this.limiters.keySet().stream().limit(toRemove).forEach(this.limiters::remove);
        }
    }
}

