/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.meisterah.serverStatusAPI.MetricStore;
import de.meisterah.serverStatusAPI.RateLimitingHandler;
import de.meisterah.serverStatusAPI.SQLiteStore;
import de.meisterah.serverStatusAPI.SecurityUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

public class RestApiServer {
    private final MetricStore store;
    private final Plugin plugin;
    private HttpServer server;
    private final int port;
    private final String bindAddress;
    private final boolean enableCors;
    private final boolean logApiAccess;
    private final int rateLimitPerMinute;
    private final Logger logger;

    public RestApiServer(MetricStore store, int port) {
        this(store, port, "0.0.0.0", false, false, 0, null);
    }

    public RestApiServer(MetricStore store, int port, String bindAddress, boolean enableCors, boolean logApiAccess, int rateLimitPerMinute, Plugin plugin) {
        this.store = store;
        this.port = port;
        this.bindAddress = bindAddress;
        this.enableCors = enableCors;
        this.logApiAccess = logApiAccess;
        this.rateLimitPerMinute = rateLimitPerMinute;
        this.plugin = plugin;
        this.logger = plugin != null ? plugin.getLogger() : Logger.getLogger("RestApiServer");
    }

    public void start() throws IOException {
        InetAddress address = InetAddress.getByName(this.bindAddress);
        this.server = HttpServer.create(new InetSocketAddress(address, this.port), 0);
        HttpHandler currentHandler = new CurrentMetricsHandler(this.store, this.enableCors, this.logApiAccess, this.logger);
        HttpHandler historyHandler = new HistoryMetricsHandler(this.store, this.enableCors, this.logApiAccess, this.logger, this.plugin);
        HttpHandler playersHandler = new PlayersHandler(this.store, this.enableCors, this.logApiAccess, this.logger);
        HttpHandler entitiesHandler = new EntitiesHandler(this.store, this.enableCors, this.logApiAccess, this.logger);
        if (this.rateLimitPerMinute > 0) {
            currentHandler = new RateLimitingHandler(currentHandler, this.rateLimitPerMinute);
            historyHandler = new RateLimitingHandler(historyHandler, this.rateLimitPerMinute);
            playersHandler = new RateLimitingHandler(playersHandler, this.rateLimitPerMinute);
            entitiesHandler = new RateLimitingHandler(entitiesHandler, this.rateLimitPerMinute);
        }
        this.server.createContext("/metrics/current", currentHandler);
        this.server.createContext("/metrics/history", historyHandler);
        this.server.createContext("/metrics/players", playersHandler);
        this.server.createContext("/metrics/entities", entitiesHandler);
        this.server.setExecutor(null);
        this.server.start();
        if ("0.0.0.0".equals(this.bindAddress)) {
            this.logger.warning("API server is binding to 0.0.0.0 (all interfaces). This exposes the API to the internet!");
            this.logger.warning("Consider setting 'api-bind-address: 127.0.0.1' in config.yml for local-only access.");
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private static void addCorsHeaders(HttpExchange exchange, boolean enableCors) {
        if (enableCors) {
            exchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET, OPTIONS");
            exchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type");
        }
    }

    private static void logAccess(HttpExchange exchange, boolean logApiAccess, Logger logger) {
        if (logApiAccess) {
            String clientIP = exchange.getRemoteAddress().getAddress().getHostAddress();
            String method = exchange.getRequestMethod();
            String path = exchange.getRequestURI().getPath();
            String query = exchange.getRequestURI().getQuery();
            logger.info(String.format("[API] %s %s%s from %s", SecurityUtils.sanitizeForLog(method), SecurityUtils.sanitizeForLog(path), query != null ? "?" + SecurityUtils.sanitizeForLog(query) : "", SecurityUtils.sanitizeForLog(clientIP)));
        }
    }

    static class CurrentMetricsHandler
    implements HttpHandler {
        private final MetricStore store;
        private final boolean enableCors;
        private final boolean logApiAccess;
        private final Logger logger;

        public CurrentMetricsHandler(MetricStore store, boolean enableCors, boolean logApiAccess, Logger logger) {
            this.store = store;
            this.enableCors = enableCors;
            this.logApiAccess = logApiAccess;
            this.logger = logger;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            RestApiServer.logAccess(exchange, this.logApiAccess, this.logger);
            RestApiServer.addCorsHeaders(exchange, this.enableCors);
            if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String json = this.store.getCurrentMetricsJson();
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, json.getBytes().length);
            OutputStream os = exchange.getResponseBody();
            os.write(json.getBytes());
            os.close();
        }
    }

    static class HistoryMetricsHandler
    implements HttpHandler {
        private final MetricStore store;
        private final boolean enableCors;
        private final boolean logApiAccess;
        private final Logger logger;
        private final Plugin plugin;

        public HistoryMetricsHandler(MetricStore store, boolean enableCors, boolean logApiAccess, Logger logger, Plugin plugin) {
            this.store = store;
            this.enableCors = enableCors;
            this.logApiAccess = logApiAccess;
            this.logger = logger;
            this.plugin = plugin;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            Map<String, String> params;
            int defaultLimit;
            RestApiServer.logAccess(exchange, this.logApiAccess, this.logger);
            RestApiServer.addCorsHeaders(exchange, this.enableCors);
            if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            int limit = defaultLimit = this.plugin != null ? this.plugin.getConfig().getInt("history-limit", 60) : 60;
            String query = exchange.getRequestURI().getQuery();
            if (query != null && (params = SecurityUtils.parseQueryParams(query)).containsKey("limit")) {
                int maxLimit = this.plugin != null ? this.plugin.getConfig().getInt("max-history-limit", 10000) : 10000;
                limit = SecurityUtils.parseIntSafe(params.get("limit"), defaultLimit, 1, maxLimit);
            }
            String json = this.store.getHistoryMetricsJson(limit);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, json.getBytes().length);
            OutputStream os = exchange.getResponseBody();
            os.write(json.getBytes());
            os.close();
        }
    }

    static class PlayersHandler
    implements HttpHandler {
        private final MetricStore store;
        private final boolean enableCors;
        private final boolean logApiAccess;
        private final Logger logger;

        public PlayersHandler(MetricStore store, boolean enableCors, boolean logApiAccess, Logger logger) {
            this.store = store;
            this.enableCors = enableCors;
            this.logApiAccess = logApiAccess;
            this.logger = logger;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            RestApiServer.logAccess(exchange, this.logApiAccess, this.logger);
            RestApiServer.addCorsHeaders(exchange, this.enableCors);
            if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String json = ((SQLiteStore)this.store).getAllPlayersJson();
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, json.getBytes().length);
            OutputStream os = exchange.getResponseBody();
            os.write(json.getBytes());
            os.close();
        }
    }

    static class EntitiesHandler
    implements HttpHandler {
        private final MetricStore store;
        private final boolean enableCors;
        private final boolean logApiAccess;
        private final Logger logger;

        public EntitiesHandler(MetricStore store, boolean enableCors, boolean logApiAccess, Logger logger) {
            this.store = store;
            this.enableCors = enableCors;
            this.logApiAccess = logApiAccess;
            this.logger = logger;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            RestApiServer.logAccess(exchange, this.logApiAccess, this.logger);
            RestApiServer.addCorsHeaders(exchange, this.enableCors);
            if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!exchange.getRequestMethod().equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            Map<String, Map<String, Integer>> entityDist = ((SQLiteStore)this.store).getMainPlugin().getEntityDistributionPerWorld();
            Map<String, Integer> entityCounts = ((SQLiteStore)this.store).getMainPlugin().getEntityCountPerWorld();
            Gson gson = new Gson();
            JsonObject distObj = new JsonObject();
            Iterator<String> iterator = entityDist.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String worldName = string = iterator.next();
                if ("normal".equalsIgnoreCase(string)) {
                    worldName = "overworld";
                }
                distObj.add(worldName, gson.toJsonTree(entityDist.get(string)));
            }
            JsonObject countsObj = new JsonObject();
            Iterator<String> iterator2 = entityCounts.keySet().iterator();
            while (iterator2.hasNext()) {
                String world3;
                String worldName = world3 = iterator2.next();
                if ("normal".equalsIgnoreCase(world3)) {
                    worldName = "overworld";
                }
                countsObj.addProperty(worldName, entityCounts.get(world3));
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("distribution", distObj);
            jsonObject.add("counts", countsObj);
            String json = gson.toJson(jsonObject);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, json.getBytes().length);
            OutputStream os = exchange.getResponseBody();
            os.write(json.getBytes());
            os.close();
        }
    }
}

