/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.meisterah.serverStatusAPI.MetricStore;
import de.meisterah.serverStatusAPI.ServerStatusAPI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLiteStore
implements MetricStore {
    private final Plugin plugin;
    private final ServerStatusAPI mainPlugin;

    public SQLiteStore(Plugin plugin, ServerStatusAPI mainPlugin) {
        this.plugin = plugin;
        this.mainPlugin = mainPlugin;
        this.init();
    }

    private void init() {
        try {
            Class.forName("org.sqlite.JDBC");
            try (Connection conn = this.getConnection();
                 Statement stmt = conn.createStatement();){
                stmt.executeUpdate("PRAGMA journal_mode=WAL");
                stmt.executeUpdate("PRAGMA busy_timeout=5000");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS tps (timestamp INTEGER, value REAL)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS memory (timestamp INTEGER, used INTEGER, max INTEGER)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS metrics_full (timestamp INTEGER, tps REAL, used INTEGER, max INTEGER, onlinePlayers INTEGER, maxPlayers INTEGER, cpuUsage REAL, loadedChunks INTEGER, entityCount INTEGER, uptimeMillis INTEGER, ping INTEGER, players TEXT, serverAddress TEXT)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY, name TEXT, totalPlaytime INTEGER)");
                stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_metrics_full_timestamp ON metrics_full(timestamp)");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("SQLite initialization failed: " + e.getMessage());
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(this.plugin.getDataFolder()) + "/metrics.db");
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate("PRAGMA busy_timeout=5000");
        }
        return conn;
    }

    public void saveFullMetrics(double tps, long used, long max, int onlinePlayers, int maxPlayers, double cpuUsage, int loadedChunks, int entityCount, long uptimeMillis, int ping, String playersJson, String serverAddress) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO metrics_full (timestamp, tps, used, max, onlinePlayers, maxPlayers, cpuUsage, loadedChunks, entityCount, uptimeMillis, ping, players, serverAddress) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");){
            ps.setLong(1, System.currentTimeMillis());
            ps.setDouble(2, tps);
            ps.setLong(3, used);
            ps.setLong(4, max);
            ps.setInt(5, onlinePlayers);
            ps.setInt(6, maxPlayers);
            ps.setDouble(7, cpuUsage);
            ps.setInt(8, loadedChunks);
            ps.setInt(9, entityCount);
            ps.setLong(10, uptimeMillis);
            ps.setInt(11, ping);
            ps.setString(12, playersJson);
            ps.setString(13, serverAddress);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save FullMetrics: " + e.getMessage());
        }
    }

    public void deleteOldMetrics(int days) {
        long cutoff = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM metrics_full WHERE timestamp < ?");){
            ps.setLong(1, cutoff);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to delete old metrics: " + e.getMessage());
        }
    }

    @Override
    public String getCurrentMetricsJson() {
        Gson gson = new Gson();
        JsonObject obj = new JsonObject();
        obj.addProperty("tps", this.mainPlugin.getLastTps());
        JsonObject mem = new JsonObject();
        mem.addProperty("used", this.mainPlugin.getLastUsed());
        mem.addProperty("max", this.mainPlugin.getLastMax());
        obj.add("memory", mem);
        obj.addProperty("timestamp", System.currentTimeMillis());
        obj.addProperty("lastUpdated", this.mainPlugin.getLastUpdated());
        obj.addProperty("onlinePlayers", this.mainPlugin.getLastOnlinePlayers());
        obj.addProperty("maxPlayers", this.mainPlugin.getLastMaxPlayers());
        obj.addProperty("cpuUsage", this.mainPlugin.getLastCpuUsage());
        obj.addProperty("loadedChunks", this.mainPlugin.getLastLoadedChunks());
        obj.addProperty("serverAddress", Bukkit.getServer().getIp() + ":" + Bukkit.getServer().getPort());
        obj.addProperty("uptimeMillis", this.mainPlugin.getUptimeMillis());
        obj.addProperty("ping", this.mainPlugin.getLastPing());
        JsonArray players = new JsonArray();
        for (ServerStatusAPI.PlayerInfo info : this.mainPlugin.getLastPlayers()) {
            JsonObject p = new JsonObject();
            p.addProperty("uuid", info.uuid.toString());
            p.addProperty("name", info.name);
            p.addProperty("ping", info.ping);
            long sessionOnlineMillis = info.sessionStart > 0L ? System.currentTimeMillis() - info.sessionStart : 0L;
            p.addProperty("sessionOnlineMillis", sessionOnlineMillis);
            players.add(p);
        }
        obj.add("players", players);
        return gson.toJson(obj);
    }

    @Override
    public String getHistoryMetricsJson(int limit) {
        Gson gson = new Gson();
        JsonArray arr = new JsonArray();
        String query = "SELECT timestamp, tps, used, max, onlinePlayers, maxPlayers, cpuUsage, loadedChunks, entityCount, uptimeMillis, ping, players, serverAddress FROM metrics_full ORDER BY timestamp DESC LIMIT ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(query);){
            int maxLimit = this.mainPlugin.getConfig().getInt("max-history-limit", 10000);
            int safeLimit = Math.max(1, Math.min(limit, maxLimit));
            ps.setInt(1, safeLimit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("timestamp", rs.getLong(1));
                obj.addProperty("tps", rs.getDouble(2));
                JsonObject mem = new JsonObject();
                mem.addProperty("used", rs.getLong(3));
                mem.addProperty("max", rs.getLong(4));
                obj.add("memory", mem);
                obj.addProperty("onlinePlayers", rs.getInt(5));
                obj.addProperty("maxPlayers", rs.getInt(6));
                obj.addProperty("cpuUsage", rs.getDouble(7));
                obj.addProperty("loadedChunks", rs.getInt(8));
                obj.addProperty("entityCount", rs.getInt(9));
                obj.addProperty("uptimeMillis", rs.getLong(10));
                obj.addProperty("ping", rs.getInt(11));
                JsonArray playersArray = new JsonArray();
                try {
                    JsonArray playersRaw = JsonParser.parseString(rs.getString(12)).getAsJsonArray();
                    for (int i = 0; i < playersRaw.size(); ++i) {
                        JsonObject playerJson = playersRaw.get(i).getAsJsonObject();
                        String uuid = playerJson.get("uuid").getAsString();
                        String name = null;
                        try (Connection conn2 = this.getConnection();
                             PreparedStatement ps2 = conn2.prepareStatement("SELECT name FROM players WHERE uuid = ?");){
                            ps2.setString(1, uuid);
                            try (ResultSet rs2 = ps2.executeQuery();){
                                if (rs2.next()) {
                                    name = rs2.getString(1);
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        if (name != null) {
                            playerJson.addProperty("name", name);
                        }
                        playersArray.add(playerJson);
                    }
                }
                catch (Exception e) {
                    playersArray = new JsonArray();
                }
                obj.add("players", playersArray);
                obj.addProperty("serverAddress", rs.getString(13));
                arr.add(obj);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to read historical metrics: " + e.getMessage());
        }
        return gson.toJson(arr);
    }

    public void setLiveStats(int onlinePlayers, int maxPlayers, double cpuUsage, int loadedChunks, int entityCount) {
        throw new UnsupportedOperationException("Unimplemented method 'setLiveStats'");
    }

    public void upsertPlayer(String uuid, String name) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO players (uuid, name, totalPlaytime) VALUES (?, ?, COALESCE((SELECT totalPlaytime FROM players WHERE uuid = ?), 0)) ON CONFLICT(uuid) DO UPDATE SET name = excluded.name");){
            ps.setString(1, uuid);
            ps.setString(2, name);
            ps.setString(3, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to upsert player: " + e.getMessage());
        }
    }

    public void addPlaytime(String uuid, long millis) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("UPDATE players SET totalPlaytime = COALESCE(totalPlaytime, 0) + ? WHERE uuid = ?");){
            ps.setLong(1, millis);
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to add playtime: " + e.getMessage());
        }
    }

    public String getAllPlayersJson() {
        Gson gson = new Gson();
        JsonArray arr = new JsonArray();
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT uuid, name, COALESCE(totalPlaytime, 0) FROM players");
            while (rs.next()) {
                long dbPlaytime;
                JsonObject o = new JsonObject();
                String uuid = rs.getString(1);
                String name = rs.getString(2);
                long totalPlaytimeMillis = dbPlaytime = rs.getLong(3);
                for (ServerStatusAPI.PlayerInfo info : this.mainPlugin.getLastPlayers()) {
                    if (!info.uuid.toString().equals(uuid)) continue;
                    if (info.sessionStart <= 0L) break;
                    totalPlaytimeMillis += System.currentTimeMillis() - info.sessionStart;
                    break;
                }
                o.addProperty("uuid", uuid);
                o.addProperty("name", name);
                o.addProperty("totalPlaytimeMillis", totalPlaytimeMillis);
                arr.add(o);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to read all players: " + e.getMessage());
        }
        return gson.toJson(arr);
    }

    public ServerStatusAPI getMainPlugin() {
        return this.mainPlugin;
    }
}

