/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import java.util.HashMap;
import java.util.Map;

public class SecurityUtils {
    public static Map<String, String> parseQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return params;
        }
        for (String param : query.split("&")) {
            String[] parts = param.split("=", 2);
            if (parts.length != 2) continue;
            params.put(parts[0], parts[1]);
        }
        return params;
    }

    public static int parseIntSafe(String value, int defaultValue, int min2, int max) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        if (!value.matches("^[0-9]+$")) {
            return defaultValue;
        }
        try {
            int parsed = Integer.parseInt(value);
            return Math.max(min2, Math.min(max, parsed));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String sanitizeForLog(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\n", "").replace("\r", "").trim();
    }
}

