/*
 * Decompiled with CFR 0.152.
 */
package de.meisterah.serverStatusAPI;

import de.meisterah.serverStatusAPI.MetricStore;
import de.meisterah.serverStatusAPI.MetricsCollector;
import de.meisterah.serverStatusAPI.RestApiServer;
import de.meisterah.serverStatusAPI.SQLiteStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerStatusAPI
extends JavaPlugin
implements TabCompleter {
    private MetricsCollector metricsCollector;
    private MetricStore metricStore;
    private RestApiServer apiServer;
    private long startTimeMillis;
    private boolean storeMetrics;
    private volatile double lastTps = 0.0;
    private volatile long lastUsed = 0L;
    private volatile long lastMax = 0L;
    private volatile int lastOnlinePlayers = 0;
    private volatile int lastMaxPlayers = 0;
    private volatile double lastCpuUsage = 0.0;
    private volatile int lastLoadedChunks = 0;
    private volatile int lastEntityCount = 0;
    private volatile int lastPing = 0;
    private volatile long lastUpdated = 0L;
    private volatile List<PlayerInfo> lastPlayers = new ArrayList<PlayerInfo>();
    private volatile Map<String, Integer> entityCountPerWorld = new ConcurrentHashMap<String, Integer>();
    private volatile Map<String, Map<String, Integer>> entityDistributionPerWorld = new ConcurrentHashMap<String, Map<String, Integer>>();
    public final Map<UUID, Long> playerSessionStart = new ConcurrentHashMap<UUID, Long>();
    public final Map<UUID, Long> playerTotalPlaytime = new ConcurrentHashMap<UUID, Long>();

    public void onEnable() {
        this.startTimeMillis = System.currentTimeMillis();
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        int apiPort = config.getInt("api-port", 8080);
        int metricsInterval = config.getInt("metrics-interval", 1);
        this.storeMetrics = config.getBoolean("store-metrics", true);
        this.getLogger().info("Metrics storage is " + (this.storeMetrics ? "enabled" : "disabled"));
        this.metricStore = new SQLiteStore((Plugin)this, this);
        this.metricsCollector = new MetricsCollector(this.metricStore, metricsInterval, this);
        Bukkit.getPluginManager().registerEvents((Listener)this.metricsCollector, (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent event) {
                UUID uuid = event.getPlayer().getUniqueId();
                String name = event.getPlayer().getName();
                ServerStatusAPI.this.playerSessionStart.put(uuid, System.currentTimeMillis());
                if (ServerStatusAPI.this.metricStore instanceof SQLiteStore && ServerStatusAPI.this.storeMetrics) {
                    ((SQLiteStore)ServerStatusAPI.this.metricStore).upsertPlayer(uuid.toString(), name);
                }
            }

            @EventHandler
            public void onQuit(PlayerQuitEvent event) {
                UUID uuid = event.getPlayer().getUniqueId();
                long logout = System.currentTimeMillis();
                Long login = ServerStatusAPI.this.playerSessionStart.remove(uuid);
                if (login != null) {
                    long session = logout - login;
                    ServerStatusAPI.this.playerTotalPlaytime.put(uuid, ServerStatusAPI.this.playerTotalPlaytime.getOrDefault(uuid, 0L) + session);
                    if (ServerStatusAPI.this.metricStore instanceof SQLiteStore && ServerStatusAPI.this.storeMetrics) {
                        ((SQLiteStore)ServerStatusAPI.this.metricStore).addPlaytime(uuid.toString(), session);
                    }
                }
            }
        }, (Plugin)this);
        this.getLogger().info("ServerStatusAPI enabled.");
        try {
            String bindAddress = config.getString("api-bind-address", "0.0.0.0");
            boolean enableCors = config.getBoolean("api-cors-enabled", false);
            boolean logApiAccess = config.getBoolean("log-api-access", false);
            int rateLimitPerMinute = config.getInt("api-rate-limit", 0);
            this.apiServer = new RestApiServer(this.metricStore, apiPort, bindAddress, enableCors, logApiAccess, rateLimitPerMinute, (Plugin)this);
            this.apiServer.start();
            this.getLogger().info("REST-API-Server started on " + bindAddress + ":" + apiPort + ".");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to start REST-API: " + e.getMessage());
        }
    }

    public void onDisable() {
        if (this.metricsCollector != null) {
            this.metricsCollector.stopCollection();
        }
        if (this.metricStore instanceof SQLiteStore && this.storeMetrics) {
            long now = System.currentTimeMillis();
            for (UUID uuid : this.playerSessionStart.keySet()) {
                Long login = this.playerSessionStart.get(uuid);
                if (login == null) continue;
                long session = now - login;
                ((SQLiteStore)this.metricStore).addPlaytime(uuid.toString(), session);
            }
        }
        if (this.apiServer != null) {
            this.apiServer.stop();
        }
        this.getLogger().info("ServerStatusAPI disabled.");
    }

    public void updateLiveStats(double tps, long used, long max, int online, int maxPlayers, double cpu, int chunks, int entities, int ping, List<PlayerInfo> players, Map<String, Integer> entityCountPerWorld, Map<String, Map<String, Integer>> entityDistributionPerWorld) {
        this.lastTps = tps;
        this.lastUsed = used;
        this.lastMax = max;
        this.lastOnlinePlayers = online;
        this.lastMaxPlayers = maxPlayers;
        this.lastCpuUsage = cpu;
        this.lastLoadedChunks = chunks;
        this.lastEntityCount = entities;
        this.lastPing = ping;
        this.lastPlayers = players;
        this.entityCountPerWorld = entityCountPerWorld;
        this.entityDistributionPerWorld = entityDistributionPerWorld;
        this.lastUpdated = System.currentTimeMillis();
    }

    public double getLastTps() {
        return this.lastTps;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public long getLastMax() {
        return this.lastMax;
    }

    public int getLastOnlinePlayers() {
        return this.lastOnlinePlayers;
    }

    public int getLastMaxPlayers() {
        return this.lastMaxPlayers;
    }

    public double getLastCpuUsage() {
        return this.lastCpuUsage;
    }

    public int getLastLoadedChunks() {
        return this.lastLoadedChunks;
    }

    public int getLastEntityCount() {
        return this.lastEntityCount;
    }

    public int getLastPing() {
        return this.lastPing;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public List<PlayerInfo> getLastPlayers() {
        return this.lastPlayers;
    }

    public Map<String, Integer> getEntityCountPerWorld() {
        return this.entityCountPerWorld;
    }

    public Map<String, Map<String, Integer>> getEntityDistributionPerWorld() {
        return this.entityDistributionPerWorld;
    }

    public long getUptimeMillis() {
        return System.currentTimeMillis() - this.startTimeMillis;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("serverstatusapi") && args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("serverstatusapi.reload")) {
                sender.sendMessage("\u00a7c[ServerStatusAPI] You don't have permission to use this command.");
                return true;
            }
            this.reloadConfig();
            int apiPort = this.getConfig().getInt("api-port", 8080);
            boolean newStoreMetrics = this.getConfig().getBoolean("store-metrics", true);
            if (newStoreMetrics != this.storeMetrics) {
                this.storeMetrics = newStoreMetrics;
                this.metricsCollector.setStoreMetrics(this.storeMetrics);
                sender.sendMessage("\u00a7a[ServerStatusAPI] Metrics storage " + (this.storeMetrics ? "enabled" : "disabled"));
            }
            try {
                if (this.apiServer != null) {
                    this.apiServer.stop();
                }
                String bindAddress = this.getConfig().getString("api-bind-address", "0.0.0.0");
                boolean enableCors = this.getConfig().getBoolean("api-cors-enabled", false);
                boolean logApiAccess = this.getConfig().getBoolean("log-api-access", false);
                int rateLimitPerMinute = this.getConfig().getInt("api-rate-limit", 0);
                this.apiServer = new RestApiServer(this.metricStore, apiPort, bindAddress, enableCors, logApiAccess, rateLimitPerMinute, (Plugin)this);
                this.apiServer.start();
                sender.sendMessage("\u00a7a[ServerStatusAPI] config.yml reloaded and API-Server restarted on " + bindAddress + ":" + apiPort + "!");
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7c[ServerStatusAPI] Error restarting API-Server: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if ((command.getName().equalsIgnoreCase("serverstatusapi") || command.getName().equalsIgnoreCase("serverstatus")) && args.length == 1 && "reload".startsWith(args[0].toLowerCase())) {
            suggestions.add("reload");
        }
        return suggestions;
    }

    public boolean isStoreMetricsEnabled() {
        return this.storeMetrics;
    }

    public static class PlayerInfo {
        public final UUID uuid;
        public final String name;
        public final int ping;
        public final long sessionStart;
        public final long totalPlaytime;

        public PlayerInfo(UUID uuid, String name, int ping, long sessionStart, long totalPlaytime) {
            this.uuid = uuid;
            this.name = name;
            this.ping = ping;
            this.sessionStart = sessionStart;
            this.totalPlaytime = totalPlaytime;
        }
    }
}

