/*
 * Decompiled with CFR 0.152.
 */
package energon.nebulalib.config;

import energon.nebulalib.config.ConfigBase;
import energon.nebulalib.config.ElementType;
import energon.nebulalib.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static final String list1 = ":#__#:";
    private static final String list2 = ":#_#:";
    private static final String util1 = ":\\|\\|:";
    public boolean exists;
    public final String version;
    public File configFile;
    public List<Category> CATEGORIES = new ArrayList<Category>();

    public Config(boolean e, String v, File f) {
        this.exists = e;
        this.version = v;
        this.configFile = f;
        this.read();
    }

    public static Config CreateConfig(Path path, String version) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File configFile = path.toFile();
        return new Config(configFile.exists(), version, configFile);
    }

    public static Config CreateConfig(String pathString, String version) {
        Path path = Paths.get(pathString, new String[0]);
        return Config.CreateConfig(path, version);
    }

    public static Config CreateConfigWithDefaultPath(String pathString, String version) {
        return Config.CreateConfig(FMLPaths.CONFIGDIR.get().resolve(pathString), version);
    }

    public void alert(String message) {
        this.exists = false;
        System.out.println(message);
    }

    public void read() {
        if (this.exists) {
            try {
                ArrayList<TEST> Structure = new ArrayList<TEST>();
                List<String> __LINES__ = Files.readAllLines(this.configFile.toPath());
                String categoryName = "";
                boolean list = false;
                Object listValues = "";
                for (int i = 0; i < __LINES__.size(); ++i) {
                    String line = __LINES__.get(i).trim();
                    if (line.isEmpty() || line.startsWith(ElementType.DESCRIPTION.getPrefix())) continue;
                    if (i == 0 && line.startsWith(ElementType.VERSION.getPrefix())) {
                        String existVersion = line.split(Pattern.quote(ElementType.EQUALS.getPrefix()))[1];
                        if (this.version.equals(existVersion)) continue;
                        this.alert("!!!Version Change!!!");
                        return;
                    }
                    if (line.contains(ElementType.CATEGORY_START.getPrefix())) {
                        categoryName = line.split(Pattern.quote(ElementType.CATEGORY_START.getPrefix()))[0];
                        continue;
                    }
                    if (line.startsWith(ElementType.STRING_LIST.getPrefix()) && line.contains(ElementType.LIST_START.getPrefix())) {
                        list = true;
                        listValues = line.substring(line.indexOf(ElementType.STRING_LIST.getPrefix())).split(Pattern.quote(ElementType.LIST_START.getPrefix()))[0] + list1;
                        continue;
                    }
                    if (list && line.startsWith(ElementType.LIST_END.getPrefix())) {
                        list = false;
                        Config.updateList(Structure, categoryName, (String)listValues);
                        continue;
                    }
                    if (list) {
                        listValues = (String)listValues + line + list2;
                        continue;
                    }
                    if (line.startsWith(ElementType.STRING.getPrefix())) {
                        Config.updateList(Structure, categoryName, line.substring(line.indexOf(ElementType.STRING.getPrefix())));
                        continue;
                    }
                    if (line.startsWith(ElementType.INT.getPrefix())) {
                        Config.updateList(Structure, categoryName, line.substring(line.indexOf(ElementType.INT.getPrefix())));
                        continue;
                    }
                    if (line.startsWith(ElementType.FLOAT.getPrefix())) {
                        Config.updateList(Structure, categoryName, line.substring(line.indexOf(ElementType.FLOAT.getPrefix())));
                        continue;
                    }
                    if (line.startsWith(ElementType.DOUBLE.getPrefix())) {
                        Config.updateList(Structure, categoryName, line.substring(line.indexOf(ElementType.DOUBLE.getPrefix())));
                        continue;
                    }
                    if (!line.startsWith(ElementType.BOOLEAN.getPrefix())) continue;
                    Config.updateList(Structure, categoryName, line.substring(line.indexOf(ElementType.BOOLEAN.getPrefix())));
                }
                for (TEST test : Structure) {
                    Category category = new Category(test.categoryName);
                    category.read(test);
                    this.CATEGORIES.add(category);
                }
            }
            catch (IOException e) {
                this.alert("!!!Read Error!!!");
                e.printStackTrace();
            }
        }
    }

    public void save() {
        if (!this.exists) {
            try (PrintWriter pw = new PrintWriter(this.configFile);){
                pw.println(ElementType.VERSION.getPrefix() + "VERSION=" + this.version);
                for (Category category : this.CATEGORIES) {
                    category.save(pw);
                }
                this.exists = true;
            }
            catch (IOException e) {
                this.alert("!!!Save Error!!!");
                e.printStackTrace();
            }
        }
    }

    public static void updateList(List<TEST> list, String categoryName, String value) {
        for (TEST test : list) {
            if (!test.categoryName.equals(categoryName)) continue;
            test.add(value);
            return;
        }
        list.add(new TEST(categoryName, value));
    }

    public void addCategoryInfo(String name, String info) {
        for (Category category : this.CATEGORIES) {
            if (!category.name.equals(name)) continue;
            category.info = info;
            return;
        }
        this.CATEGORIES.add(new Category(name, info));
    }

    public Category getCategory(String name) {
        for (Category category : this.CATEGORIES) {
            if (!category.name.equals(name)) continue;
            return category;
        }
        Category c = new Category(name);
        this.CATEGORIES.add(c);
        return c;
    }

    public String getString(String element, String category, String defaultValue, String description) {
        return (String)this.getCategory(category).getElementString(this, element, defaultValue, description).getValue();
    }

    public String[] getStringList(String element, String category, String[] defaultValue, String description) {
        return (String[])this.getCategory(category).getElementStringList(this, element, defaultValue, description).getValue();
    }

    public int getInt(String element, String category, int defaultValue, int min, int max, String description) {
        return (Integer)this.getCategory(category).getElementInt(this, element, defaultValue, min, max, description).getValue();
    }

    public float getFloat(String element, String category, float defaultValue, float min, float max, String description) {
        return ((Float)this.getCategory(category).getElementFloat(this, element, defaultValue, min, max, description).getValue()).floatValue();
    }

    public double getDouble(String element, String category, double defaultValue, double min, double max, String description) {
        return (Double)this.getCategory(category).getElementDouble(this, element, defaultValue, min, max, description).getValue();
    }

    public Boolean getBoolean(String element, String category, Boolean defaultValue, String description) {
        return (Boolean)this.getCategory(category).getElementBoolean(this, element, defaultValue, description).getValue();
    }

    public static class TEST {
        public String categoryName;
        public String value = "";

        public TEST(String n) {
            this.categoryName = n;
        }

        public TEST(String n, String v) {
            this(n);
            this.value = this.value + v;
        }

        public void add(String add) {
            this.value = this.value + Config.util1 + add;
        }

        public String[] get() {
            return this.value.split(Pattern.quote(Config.util1));
        }

        public String toString() {
            return "Name:" + this.categoryName + ", Value:" + this.value;
        }
    }

    public static class Category {
        public final String name;
        public String info;
        public List<ConfigBase> elements = new ArrayList<ConfigBase>();

        public Category(String n) {
            this.name = n;
        }

        public Category(String n, String inf) {
            this(n);
            this.info = inf;
        }

        public ConfigBase get(String name, Config config) {
            for (ConfigBase element : this.elements) {
                if (!element.name.equals(name)) continue;
                return element;
            }
            config.exists = false;
            return null;
        }

        public ConfigBase getElementString(Config config, String name, String defaultValue, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new StringElement(name, defaultValue, description);
                this.elements.add(base);
            }
            if (base instanceof StringElement) {
                ((StringElement)base).lcUpdate(description, defaultValue);
            }
            return base;
        }

        public ConfigBase getElementStringList(Config config, String name, String[] defaultValue, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new StringListElement(name, defaultValue, description);
                this.elements.add(base);
            }
            if (base instanceof StringListElement) {
                ((StringListElement)base).lcUpdate(description, defaultValue);
            }
            return base;
        }

        public ConfigBase getElementInt(Config config, String name, int defaultValue, int minimum, int maximum, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new IntElement(name, defaultValue, minimum, maximum, description);
                this.elements.add(base);
            }
            if (base instanceof IntElement) {
                ((IntElement)base).lcUpdate(description, defaultValue, minimum, maximum);
            }
            return base;
        }

        public ConfigBase getElementFloat(Config config, String name, float defaultValue, float minimum, float maximum, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new FloatElement(name, defaultValue, minimum, maximum, description);
                this.elements.add(base);
            }
            if (base instanceof FloatElement) {
                ((FloatElement)base).lcUpdate(description, defaultValue, minimum, maximum);
            }
            return base;
        }

        public ConfigBase getElementDouble(Config config, String name, double defaultValue, double minimum, double maximum, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new DoubleElement(name, defaultValue, minimum, maximum, description);
                this.elements.add(base);
            }
            if (base instanceof DoubleElement) {
                ((DoubleElement)base).lcUpdate(description, defaultValue, minimum, maximum);
            }
            return base;
        }

        public ConfigBase getElementBoolean(Config config, String name, Boolean defaultValue, String description) {
            ConfigBase base = this.get(name, config);
            if (base == null) {
                base = new BooleanElement(name, defaultValue, description);
                this.elements.add(base);
            }
            if (base instanceof BooleanElement) {
                ((BooleanElement)base).lcUpdate(description, defaultValue);
            }
            return base;
        }

        public void read(TEST test) {
            for (String parts : test.get()) {
                String[] check;
                if (parts.startsWith(ElementType.STRING_LIST.getPrefix())) {
                    check = parts.split(Pattern.quote(Config.list1));
                    StringListElement base = new StringListElement(check[0].substring(3), check[1].split(Pattern.quote(Config.list2)));
                    this.elements.add(base);
                    continue;
                }
                if (parts.startsWith(ElementType.STRING.getPrefix())) {
                    check = parts.substring(2).split(Pattern.quote(ElementType.EQUALS.getPrefix()));
                    this.elements.add(new StringElement(check[0], check[1]));
                    continue;
                }
                if (parts.startsWith(ElementType.INT.getPrefix())) {
                    check = parts.substring(2).split(Pattern.quote(ElementType.EQUALS.getPrefix()));
                    this.elements.add(new IntElement(check[0], Integer.parseInt(check[1])));
                    continue;
                }
                if (parts.startsWith(ElementType.FLOAT.getPrefix())) {
                    check = parts.substring(2).split(Pattern.quote(ElementType.EQUALS.getPrefix()));
                    this.elements.add(new FloatElement(check[0], Float.parseFloat(check[1])));
                    continue;
                }
                if (parts.startsWith(ElementType.DOUBLE.getPrefix())) {
                    check = parts.substring(2).split(Pattern.quote(ElementType.EQUALS.getPrefix()));
                    this.elements.add(new DoubleElement(check[0], Double.parseDouble(check[1])));
                    continue;
                }
                if (!parts.startsWith(ElementType.BOOLEAN.getPrefix())) continue;
                check = parts.substring(2).split(Pattern.quote(ElementType.EQUALS.getPrefix()));
                this.elements.add(new BooleanElement(check[0], Boolean.parseBoolean(check[1])));
            }
        }

        public void save(PrintWriter writer) {
            writer.println("");
            writer.println("");
            writer.println(Utilities.repeat(ElementType.DESCRIPTION.getPrefix(), 106));
            writer.println(ElementType.DESCRIPTION.getPrefix() + " " + this.name);
            writer.println(ElementType.DESCRIPTION.getPrefix() + "--------------------------------------------------------------------------------------------------------" + ElementType.DESCRIPTION.getPrefix());
            if (this.info == null) {
                writer.println(ElementType.DESCRIPTION.getPrefix());
            } else {
                for (String parts : this.info.split("\\n")) {
                    writer.println(ElementType.DESCRIPTION.getPrefix() + " " + parts);
                }
            }
            writer.println(Utilities.repeat(ElementType.DESCRIPTION.getPrefix(), 106));
            writer.println(this.name + ElementType.CATEGORY_START.getPrefix());
            for (ConfigBase element : this.elements) {
                element.save(writer);
                writer.println("");
            }
            writer.println(ElementType.CATEGORY_END.getPrefix());
        }
    }

    public static class BooleanElement
    extends ConfigBase {
        public Boolean value;
        public Boolean defaultValue;

        public BooleanElement(String n, Boolean defValue, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = defValue;
        }

        public BooleanElement(String n, Boolean newValue) {
            super(n, null);
            this.value = newValue;
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.BOOLEAN.getPrefix() + this.name + ElementType.EQUALS.getPrefix() + this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public void lcUpdate(String description, Boolean defValue) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = defValue;
            }
        }

        @Override
        public String getDefault() {
            return "\t[default: " + this.value + " ]";
        }
    }

    public static class DoubleElement
    extends ConfigBase {
        public double value;
        public Double defaultValue;
        public Double minimum;
        public Double maximum;

        public DoubleElement(String n, double defValue, double min, double max, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = defValue;
            this.minimum = min;
            this.maximum = max;
        }

        public DoubleElement(String n, double defaultValue) {
            super(n, null);
            this.value = defaultValue;
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.DOUBLE.getPrefix() + this.name + ElementType.EQUALS.getPrefix() + this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getDefault() {
            return "\t[range: " + (this.minimum == null ? -2.147483648E9 : this.minimum) + " ~ " + (this.maximum == null ? 2.147483647E9 : this.maximum) + ", default: " + this.defaultValue + " ]";
        }

        public void lcUpdate(String description, double defValue, double min, double max) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = defValue;
            }
            if (this.minimum == null) {
                this.minimum = min;
            }
            if (this.maximum == null) {
                this.maximum = max;
            }
        }
    }

    public static class FloatElement
    extends ConfigBase {
        public float value;
        public Float defaultValue;
        public Float minimum;
        public Float maximum;

        public FloatElement(String n, float defValue, float min, float max, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = Float.valueOf(defValue);
            this.minimum = Float.valueOf(min);
            this.maximum = Float.valueOf(max);
        }

        public FloatElement(String n, float defaultValue) {
            super(n, null);
            this.value = defaultValue;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.FLOAT.getPrefix() + this.name + ElementType.EQUALS.getPrefix() + this.value);
        }

        @Override
        public String getDefault() {
            return "\t[range: " + (this.minimum == null ? -2.1474836E9f : this.minimum.floatValue()) + " ~ " + (this.maximum == null ? 2.1474836E9f : this.maximum.floatValue()) + ", default: " + this.defaultValue + " ]";
        }

        public void lcUpdate(String description, float defValue, float min, float max) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = Float.valueOf(defValue);
            }
            if (this.minimum == null) {
                this.minimum = Float.valueOf(min);
            }
            if (this.maximum == null) {
                this.maximum = Float.valueOf(max);
            }
        }
    }

    public static class IntElement
    extends ConfigBase {
        public int value;
        public Integer defaultValue;
        public Integer minimum;
        public Integer maximum;

        public IntElement(String n, int defValue, int min, int max, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = defValue;
            this.minimum = min;
            this.maximum = max;
        }

        public IntElement(String n, int newValue) {
            super(n, null);
            this.value = newValue;
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.INT.getPrefix() + this.name + ElementType.EQUALS.getPrefix() + this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getDefault() {
            return "\t[range: " + (this.minimum == null ? Integer.MIN_VALUE : this.minimum) + " ~ " + (this.maximum == null ? Integer.MAX_VALUE : this.maximum) + ", default: " + this.defaultValue + " ]";
        }

        public void lcUpdate(String description, int defValue, int min, int max) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = defValue;
            }
            if (this.minimum == null) {
                this.minimum = min;
            }
            if (this.maximum == null) {
                this.maximum = max;
            }
        }
    }

    public static class StringListElement
    extends ConfigBase {
        public String[] value;
        public String[] defaultValue;

        public StringListElement(String n, String[] defValue, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = defValue;
        }

        public StringListElement(String n, String[] newValue) {
            super(n, null);
            this.value = newValue;
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.STRING_LIST.getPrefix() + this.name + ElementType.LIST_START.getPrefix());
            if (this.value != null) {
                for (String parts : this.value) {
                    writer.println("\t\t" + parts);
                }
            }
            writer.println("\t" + ElementType.LIST_END.getPrefix());
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getDefault() {
            StringBuilder sb = new StringBuilder();
            sb.append("\t[default: ");
            for (int i = 0; i < this.value.length; ++i) {
                sb.append("[").append(this.value[i]).append("]");
                if (i == this.value.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }

        public void lcUpdate(String description, String[] defValue) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = defValue;
            }
        }
    }

    public static class StringElement
    extends ConfigBase {
        public String value;
        public String defaultValue;

        public StringElement(String n, String defValue, String description) {
            super(n, description);
            this.value = defValue;
            this.defaultValue = defValue;
        }

        public StringElement(String n, String newValue) {
            super(n, null);
            this.value = newValue;
        }

        @Override
        public void save(PrintWriter writer) {
            super.save(writer);
            writer.println("\t" + ElementType.STRING.getPrefix() + this.name + ElementType.EQUALS.getPrefix() + this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public void lcUpdate(String description, String defValue) {
            if (this.info == null) {
                this.info = description;
            }
            if (this.defaultValue == null) {
                this.defaultValue = defValue;
            }
        }

        @Override
        public String getDefault() {
            return "\t[default: " + this.value + " ]";
        }
    }
}

