/*
 * Decompiled with CFR 0.152.
 */
package energon.nebulalib.entity;

import energon.nebulalib.config.Config;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class EntityAttributes {
    public double health;
    public double movement_speed;
    public double follow_range;
    public double attack_damage;
    public double armor;
    public double armor_toughness;
    public double knockback;

    public EntityAttributes(double h, double m, double f, double a, double ar, double ar_t, double kb) {
        this.health = h;
        this.movement_speed = m;
        this.follow_range = f;
        this.attack_damage = a;
        this.armor = ar;
        this.armor_toughness = ar_t;
        this.knockback = kb;
    }

    public void increaseHealth(float multi) {
        if (multi != 1.0f) {
            this.health *= (double)multi;
        }
    }

    public void increaseMovement_Speed(float multi) {
        if (multi != 1.0f) {
            this.movement_speed *= (double)multi;
        }
    }

    public void increaseFollow_Range(float multi) {
        if (multi != 1.0f) {
            this.follow_range *= (double)multi;
        }
    }

    public void increaseAttackDamage(float multi) {
        if (multi != 1.0f) {
            this.attack_damage *= (double)multi;
        }
    }

    public void increaseArmor(float multi) {
        if (multi != 1.0f) {
            this.armor *= (double)multi;
        }
    }

    public void increaseArmor_Toughness(float multi) {
        if (multi != 1.0f) {
            this.armor_toughness *= (double)multi;
        }
    }

    public void increaseKnockback(float multi) {
        if (multi != 1.0f) {
            this.knockback *= (double)multi;
        }
    }

    public void configCompatibility(Config config, String category) {
        this.health = config.getDouble("health", category, this.health, 0.0, 999999.0, "Health.");
        this.movement_speed = config.getDouble("movement_speed", category, this.movement_speed, 0.0, 999999.0, "Movement Speed.");
        this.follow_range = config.getDouble("follow_range", category, this.follow_range, 0.0, 999999.0, "Follow Range.");
        this.attack_damage = config.getDouble("attack_damage", category, this.attack_damage, 0.0, 999999.0, "Attack Damage.");
        this.armor = config.getDouble("armor", category, this.armor, 0.0, 999999.0, "Armor.");
        this.armor_toughness = config.getDouble("armor_toughness", category, this.armor_toughness, 0.0, 999999.0, "Armor Toughness.");
        this.knockback = config.getDouble("knockback", category, this.knockback, 0.0, 999999.0, "Knockback.");
    }

    public <T extends LivingEntity> AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, this.health).add(Attributes.MOVEMENT_SPEED, this.movement_speed).add(Attributes.FOLLOW_RANGE, this.follow_range).add(Attributes.ATTACK_DAMAGE, this.attack_damage).add(Attributes.ARMOR, this.armor).add(Attributes.ARMOR_TOUGHNESS, this.armor_toughness).add(Attributes.KNOCKBACK_RESISTANCE, this.knockback);
    }
}

