/*
 * Decompiled with CFR 0.152.
 */
package energon.nebulalib.entity;

import energon.nebulalib.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityRule {
    public static Map<String, Class<? extends LivingEntity>> AVAILABLE = new HashMap<String, Class<? extends LivingEntity>>();
    public List<String> friendsString = new ArrayList<String>();
    public List<Class<? extends LivingEntity>> friendsClass = new ArrayList<Class<? extends LivingEntity>>();
    public List<String> targetsString = new ArrayList<String>();
    public List<Class<? extends LivingEntity>> targetsClass = new ArrayList<Class<? extends LivingEntity>>();
    public boolean listFriendsRev;
    public boolean firstFriends;
    public boolean notPresentFriend;
    public Class<? extends LivingEntity> owner = null;
    public String[] values;

    public EntityRule(boolean rev, boolean firstF, boolean noPresentF, String[] v) {
        this.listFriendsRev = rev;
        this.firstFriends = firstF;
        this.notPresentFriend = noPresentF;
        this.values = v;
    }

    public EntityRule(String[] v, boolean noPresentF) {
        this(false, true, noPresentF, v);
    }

    public void selfGenerate() {
        this.generate(this.values);
    }

    public void generate(String[] list) {
        for (String element : list) {
            if (element.contains(".")) {
                Class<Object> test;
                if (element.contains("/")) {
                    test = null;
                    try {
                        test = Class.forName(element.replace(".class", "").replace("!", ""));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (test == null || !LivingEntity.class.isAssignableFrom(test)) continue;
                    Class<Object> clazz = test;
                    if (element.contains("!")) {
                        this.targetsClass.add(clazz);
                        continue;
                    }
                    this.friendsClass.add(clazz);
                    continue;
                }
                test = this.fun(element.replace("!", ""));
                if (test == null) continue;
                if (element.contains("!")) {
                    this.targetsClass.add(test);
                    continue;
                }
                this.friendsClass.add(test);
                continue;
            }
            if (element.contains("!")) {
                this.targetsString.add(element.replace("!", ""));
                continue;
            }
            this.friendsString.add(element);
        }
    }

    public Class<? extends LivingEntity> fun(String name) {
        return name.equals("this.class") ? this.owner : AVAILABLE.get(name);
    }

    public boolean friendly(LivingEntity target) {
        if (this.listFriendsRev) {
            return this.testCls(target) && this.testName(target);
        }
        return this.testCls(target) || this.testName(target);
    }

    public boolean canAttack(LivingEntity target) {
        return !this.testCls(target) || !this.testName(target);
    }

    public boolean testCls(LivingEntity target) {
        if (this.firstFriends) {
            for (Class<? extends LivingEntity> friend : this.friendsClass) {
                if (!friend.isInstance(target)) continue;
                return !this.listFriendsRev;
            }
            for (Class<? extends LivingEntity> entity : this.targetsClass) {
                if (!entity.isInstance(target)) continue;
                return this.listFriendsRev;
            }
        } else {
            for (Class<? extends LivingEntity> entity : this.targetsClass) {
                if (!entity.isInstance(target)) continue;
                return this.listFriendsRev;
            }
            for (Class<? extends LivingEntity> friend : this.friendsClass) {
                if (!friend.isInstance(target)) continue;
                return !this.listFriendsRev;
            }
        }
        return this.listFriendsRev || this.notPresentFriend;
    }

    public boolean testName(LivingEntity target) {
        ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.getType());
        if (registryName == null) {
            return true;
        }
        if (this.firstFriends) {
            for (String elements : this.friendsString) {
                if (!(elements.contains(":") ? elements.equals(registryName.toString()) : elements.equals(registryName.getNamespace()))) continue;
                return !this.listFriendsRev;
            }
            for (String elements : this.targetsString) {
                if (!(elements.contains(":") ? elements.equals(registryName.toString()) : elements.equals(registryName.getNamespace()))) continue;
                return this.listFriendsRev;
            }
        } else {
            for (String elements : this.targetsString) {
                if (!(elements.contains(":") ? elements.equals(registryName.toString()) : elements.equals(registryName.getNamespace()))) continue;
                return this.listFriendsRev;
            }
            for (String elements : this.friendsString) {
                if (!(elements.contains(":") ? elements.equals(registryName.toString()) : elements.equals(registryName.getNamespace()))) continue;
                return !this.listFriendsRev;
            }
        }
        return this.listFriendsRev || this.notPresentFriend;
    }

    public void configCompatibility(Config config, String category) {
        this.values = config.getStringList("relationships", category, this.values, "Manages relationships between entities. Exp.\n  \"monster.class\" \u2014 friendly toward all monsters,\n  \"!animal.class\" \u2014 aggressive toward all animals,\n  \"!minecraft\" \u2014 hostile toward all Minecraft entities,\n  \"!minecraft:zombie\" \u2014 targets only zombies.\n AVAILABLE: " + String.valueOf(AVAILABLE.keySet()));
    }

    static {
        AVAILABLE.putIfAbsent("monster.class", Monster.class);
        AVAILABLE.putIfAbsent("animal.class", Animal.class);
        AVAILABLE.putIfAbsent("living.class", LivingEntity.class);
        AVAILABLE.putIfAbsent("player.class", Player.class);
    }
}

