/*
 * Decompiled with CFR 0.152.
 */
package byfr0n.gamemodedetector;

import byfr0n.gamemodedetector.modmenu.Config;
import byfr0n.gamemodedetector.notification.ChatNotification;
import byfr0n.gamemodedetector.rendering.NotificationRenderer;
import byfr0n.gamemodedetector.utils.PlayerUtils;
import byfr0n.gamemodedetector.utils.SoundUtils;
import byfr0n.gamemodedetector.utils.TabRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gamemodedetector
implements ClientModInitializer {
    public static final Config CONFIG = Config.load();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Gamemode Detector");
    public static TabRenderer tabRenderer = new TabRenderer();
    private static final Map<UUID, class_1934> lastGamemodes = new HashMap<UUID, class_1934>();

    public void onInitializeClient() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> NotificationRenderer.render(drawContext));
        SoundUtils.registerSounds();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || client.method_1562() == null) {
                return;
            }
            for (class_1657 player : client.field_1687.method_18456()) {
                if (Gamemodedetector.CONFIG.ignoreLocalPlayer && player == client.field_1724) continue;
                class_1934 currentGamemode = PlayerUtils.getPlayerGamemode(player);
                UUID playerId = player.method_5667();
                if (currentGamemode == null || currentGamemode == lastGamemodes.get(playerId)) continue;
                SoundUtils.playGamemodeSound();
                new ChatNotification(player.method_5477().getString() + " switched to " + currentGamemode.method_8383().getString()).send();
                NotificationRenderer.addNotification(player.method_5477().getString() + " changed to " + currentGamemode.method_8383().getString());
                lastGamemodes.put(playerId, currentGamemode);
            }
        });
    }
}

